<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\VerifiesEmails;
use App\Models\User;
use App\Services\OTP\MsgClub;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class OtpController extends Controller
{
    use VerifiesEmails;

    protected $redirectTo = '/';

    public function __construct()
    {
        // $this->middleware('auth');
    }

    // public function otp(Request $request)
    // {
    //     $mobile = $request->input('mb');
    //     $serverUrl = "msg.msgclub.net";
    //     $authKey = '73956ead71c21196e44ba9bf1523f8a';
    //     $msg = rand(1005, 9999);

    //     $postData = [
    //         'mobileNumbers' => $mobile,
    //         'smsContent' => "Your 1 Time OTP for MeFashion is " . $msg,
    //         'senderId' => 'DEMOOS',
    //         'routeId' => '1',
    //         "smsContentType" => 'english'
    //     ];

    //     $url = "http://" . $serverUrl . "/rest/services/sendSMS/sendGroupSms?AUTH_KEY=" . $authKey;

    //     $data_json = json_encode($postData);

    //     $ch = curl_init();
    //     curl_setopt_array($ch, [
    //         CURLOPT_URL => $url,
    //         CURLOPT_HTTPHEADER => ['Content-Type: application/json', 'Content-Length: ' . strlen($data_json)],
    //         CURLOPT_RETURNTRANSFER => true,
    //         CURLOPT_POST => true,
    //         CURLOPT_POSTFIELDS => $data_json,
    //         CURLOPT_SSL_VERIFYHOST => 0,
    //         CURLOPT_SSL_VERIFYPEER => 0
    //     ]);

    //     $output = curl_exec($ch);

    //     if (curl_errno($ch)) {
    //         curl_close($ch);
    //         return response()->json([
    //             'result' => '0',
    //             'message' => 'cURL Error: ' . curl_error($ch)
    //         ]);
    //     }
    //     curl_close($ch);

    //     $obj = json_decode($output);

    //     if ($obj->responseCode == 3001) {
    //         $userExists = DB::table('users')->where('phone', '=', $mobile)->exists();

    //         if (!$userExists) {
    //             $res = DB::table('users')->insert([
    //                 'phone' => $mobile,
    //                 'verification_code' => $msg,
    //                 'isCodeVerified' => 'No',
    //                 'created_at' => Carbon::now(),
    //                 'updated_at' => Carbon::now()
    //             ]);

    //             return response()->json([
    //                 'result' => $res ? '1' : '0',
    //                 'message' => $res ? 'OTP sent successfully' : 'Failed to save OTP'
    //             ]);
    //         } else {
    //             $ups = DB::table('users')->where('phone', $mobile)->update([
    //                 'verification_code' => $msg,
    //                 'isCodeVerified' => 'No',
    //                 'updated_at' => Carbon::now()
    //             ]);

    //             return response()->json([
    //                 'result' => $ups ? '1' : '0',
    //                 'message' => $ups ? 'OTP sent successfully' : 'Failed to update OTP'
    //             ]);
    //         }
    //     } else {
    //         return response()->json([
    //             'result' => '0',
    //             'message' => 'Failed to send OTP via SMS API'
    //         ]);
    //     }
    // }

    public function otp(Request $request) {
        
        try {
            $mobile = $request->input('mb');
            $mobile = format_mobile_for_db($mobile);

            $msg_club = new MsgClub();
            $res = $msg_club->sendSms($mobile);
            if($res['success']) {
                $userExists = User::where('phone', '=', $mobile)->exists();
    
                if (!$userExists) {
                    $user_res = User::insert([
                        'phone' => $mobile,
                        'verification_code' => $res['otp'],
                        'isCodeVerified' => 'No',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now()
                    ]);
                } else {
                    $user_res = User::where('phone', $mobile)->update([
                        'verification_code' => $res['otp'],
                        'isCodeVerified' => 'No',
                        'updated_at' => Carbon::now()
                    ]);
                }
    
                return response()->json([
                    'result' => $user_res ? '1' : '0',
                    'message' => $user_res ? 'OTP sent successfully' : 'Failed to update OTP',
                    // 'otp'       => $res['otp'],
                ]);
            }
            throw new \Exception($res['message']);
        } catch (\Throwable $th) {
            Log::error('Otp Send Error: ' . $th->getMessage());
            return response()->json([
                'result' => '0',
                'message' => 'Failed to send OTP'
            ]);
        }
    }

    public function vOtp(Request $request)
    {
        $mobile = $request->input('mb');
        $mobile = format_mobile_for_db($mobile);
        $otp = $request->input('otp');

        $user = User::where('phone', '=', $mobile)->first();

        if (!$user) {
            return response()->json([
                'result' => '0',
                'message' => 'User not found'
            ]);
        }

        if (intval($user->verification_code) === intval($otp)) {
            $dt = Carbon::now()->toDateTimeString();
            $updated = User::where('phone', $mobile)
                ->update([
                    'email_verified_at' => $dt,
                    'isCodeVerified' => 'Yes',
                ]);

            if ($updated) {
                Auth::login($user);

                // Check if user is fully registered (all required fields present)
                $isFullyRegistered = $user->user_type && $user->name;

                if ($isFullyRegistered) {
                    return response()->json([
                        'result' => '1',
                        'user_type' => $user->user_type,
                        'exists' => true,
                        'redirect' => $user->user_type === 'seller' ? route('dashboard') : route('home'),
                        'message' => 'OTP verified successfully. Redirecting to ' . ($user->user_type === 'seller' ? 'dashboard.' : 'home.')
                    ]);
                    
                }

                // Incomplete profile or new user
                return response()->json([
                    'result' => '1',
                    'user_type' => null,
                    'exists' => false,
                    'mobile' => $mobile,
                    'message' => ''
                ]);
            } else {
                return response()->json([
                    'result' => '2',
                    'message' => 'Failed to update verification status'
                ]);
            }
        } else {
            return response()->json([
                'result' => '0',
                'message' => 'Invalid OTP'
            ]);
        }
    }

    protected function formatMobileNumber($mobileNumber) {
        // Remove any spaces or special characters
        $mobileNumber = preg_replace('/\D/', '', $mobileNumber);
    
        // Check if the number is exactly 10 digits and does not start with "91"
        if (strlen($mobileNumber) === 10 && !preg_match('/^91/', $mobileNumber)) {
            $mobileNumber = "91" . $mobileNumber;
        }
    
        return $mobileNumber;
    }
}