<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Services\OTP\MsgClub;
use Illuminate\Http\Request;

class FeedBackController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware(['permission:send_bulk_sms'])->only('index');
    // }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
        return view('backend.otp_systems.feedback.index', compact('users'));
    }

    //send message to multiple users
    public function send(Request $request)
    {
        foreach ($request->user_phones as $key => $phone) {
            $user = User::where('phone', $phone)->first();
            $sms = "Hi $user->name, How was your experience with us? Please share your feedback here https://g.page/r/CV4zP3CNLI-GEBM/review - Akshat Healthcare";
            $msg_club = new MsgClub();
            $msg_res = $msg_club->send($phone, $sms);
        }
        var_dump($msg_res);

        // flash(translate('Feedback has been sent.'))->success();
        // return redirect()->route('admin.dashboard');
    }
}
