<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\SendSmsService;
use App\Models\User;
use App\Services\OTP\MsgClub;

class SmsController extends Controller
{
    public function __construct()
    {
        // Staff Permission Check
        $this->middleware(['permission:send_bulk_sms'])->only('index');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
        return view('backend.otp_systems.sms.index', compact('users'));
    }

    //send message to multiple users
    public function send(Request $request)
    {
        foreach ($request->user_phones as $key => $phone) {
            $user = User::where('phone', $phone)->first();
            $sms = "Hi $user->name, Get $request->discount % Discount on Pharma Products at Akshat Healthcare! Use code $request->code, Grab this Deal: https://akshathealthcare.in";
            $msg_club = new MsgClub();
            $msg_res = $msg_club->send($phone, $sms);
        }

        flash(translate('SMS has been sent.'))->success();
        return redirect()->route('admin.dashboard');
    }
}
