<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use App\Models\Category;

class MenuServiceProvider extends ServiceProvider
{

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $categories = Category::with('subCategories')->where('parent_id', 0)->get();
        
        // dd($categories->toArray());
        
        // Share all categories to all the views
        View::share('nav_categories', $categories);
    }
}
