<?php

namespace App\Services\OTP;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class MsgClub
{
    protected $authKey;
    protected $senderId;
    protected $serverUrl;
    protected $route;

    public function __construct()
    {
        $this->authKey = env('MSGCLUB_AUTH_KEY', '73956ead71c21196e44ba9bf1523f8a');
        $this->senderId = env('MSGCLUB_SENDER_ID', 'AKHCRE');
        $this->serverUrl = env('MSGCLUB_SERVER_URL', "msg.msgclub.net");
        $this->route = env('MSGCLUB_ROUTE', '1');
    }

    public function sendSms($mobileNumber)
    {
        $otp = rand(1005, 9999);
        $message = "Your Akshat Healthcare OTP is $otp and valid for 2 mins. Stay safe & Healthy Thank you.";
        // $message = "Your 1 Time OTP for MeFashion is $otp.";
        $res = $this->send($mobileNumber, $message);
        $res['otp'] = $otp;
        return $res;
    }

    public function send($mobileNumber, $message)
    {
        // return [
        //     'success'   => true,
        //     'message'   => 'SMS sent successfully!',
        //     'response'  => []
        // ];
        try {
            $mobile_str = get_string($mobileNumber);
            $mobileNumbers = explode(',', $mobile_str);
            $mobileNumbers = array_map(function ($mobile) {
                return format_mobile($mobile, 91);
            }, $mobileNumbers);
            $mobileNumbers = get_string($mobileNumbers);
            
            // API URL
            $url = "https://{$this->serverUrl}/rest/services/sendSMS/sendGroupSms";
                
            // dd([
            //     'AUTH_KEY' => $this->authKey,
            //     'mobileNos' => $mobileNumbers,
            //     'message' => $message,
            //     'senderId' => $this->senderId,
            //     'routeId' => $this->route,
            //     'smsContentType' => 'english'
            // ]);
            // Send request
            $response = Http::get($url, [
                'AUTH_KEY' => $this->authKey,
                'mobileNos' => $mobileNumbers,
                'message' => $message,
                'senderId' => $this->senderId,
                'routeId' => $this->route,
                'smsContentType' => 'english'
            ]);

            // Convert response to array
            $responseData = $response->json();
            $statusCode = $responseData['responseCode'] ?? $responseData['status'] ?? 3074; // Default to "Invalid Request"
            $statusCode = intval($statusCode);

            // Map status codes to messages
            $statusMessages = $this->getStatusMessages();
            $statusMessage = $statusMessages[$statusCode] ?? 'Unknown Error';

            // Check if SMS was successfully sent
            if ($statusCode === 3001) {
                return [
                    'success'   => true,
                    'message'   => 'SMS sent successfully!',
                    'response'  => $responseData
                ];
            } else {
                throw new \Exception("SMS Failed: " . $statusMessage. ' Response: '.json_encode($responseData));
            }

        } catch (\Exception $e) {
            Log::error('SMS Sending Error: ' . $e->getMessage() . ' For Mobile: '.$mobileNumber);

            return [
                'success' => false,
                'message' => 'Failed to send SMS',
            ];
        }
    }

    private function getStatusMessages()
    {
        return [
            3001 => 'Success',
            3002 => 'Invalid URL',
            3003 => 'Invalid User/Password',
            3004 => 'Invalid Message Type',
            3005 => 'Invalid Message',
            3006 => 'Invalid Destination',
            3007 => 'Invalid Source',
            3008 => 'Invalid DLR Field',
            3009 => 'Authentication Failed',
            3010 => 'Internal Error',
            3011 => 'Insufficient Balance',
            3012 => 'Response Timeout',
            3013 => 'Invalid Request Content Type',
            3014 => 'Missing Mobile Number',
            3015 => 'SMS Content for Approval',
            3016 => 'Missing Required Parameter',
            3017 => 'FAIL',
            3018 => 'Expired Account',
            3019 => 'Null Pointer Exception',
            3020 => 'Empty Username',
            3021 => 'Empty Password',
            3022 => 'Username Not Available',
            3023 => 'Session Expired',
            3024 => 'Already Exist',
            3025 => 'Empty Group Name',
            3026 => 'Empty Contact Name',
            3027 => 'Empty Mobile Number',
            3028 => 'Empty Group Id',
            3029 => 'Empty City Name',
            3030 => 'Empty Occupation',
            3041 => 'Empty E-Mail Id',
            3042 => 'Group Not Exist',
            3043 => 'Empty Message',
            3044 => 'Empty Route Id',
            3045 => 'Empty Sender Id',
            3047 => 'Empty Draft Id',
            3048 => 'Empty First Name',
            3049 => 'Empty Last Name',
            3050 => 'Empty Balance',
            3051 => 'Empty Role Id',
            3052 => 'Invalid Username Length',
            3053 => 'Empty Expiry Date',
            3054 => 'Invalid Date',
            3055 => 'Empty Client Id',
            3056 => 'Invalid Status',
            3057 => 'Empty Country Name',
            3058 => 'Empty State Name',
            3059 => 'Session Expired',
            3060 => 'Empty Date',
            3061 => 'Access Denied',
            3062 => 'Empty Old Password',
            3063 => 'Password Not Matching',
            3064 => 'Empty SMS',
            3065 => 'Empty Amount',
            3066 => 'Empty Address',
            3067 => 'Empty RequestId',
            3068 => 'Empty Group and Mobile Number',
            3069 => 'Empty Description',
            3070 => 'Fail to Change Role Id',
            3071 => 'Empty CallerId',
            3072 => 'Empty File URL and Draft',
            3073 => 'Empty Duration',
            3074 => 'Invalid Request',
            3075 => 'Invalid Audio File',
            3076 => 'Missing Upload File'
        ];
    }
}
