<?php

namespace App\Services;

use AizPackages\CombinationGenerate\Services\CombinationService;
use App\Models\ProductStock;
use App\Utility\ProductUtility;

class ProductStockService
{
    public function store(array $data, $product)
    {
        $collection = collect($data);

        $options = ProductUtility::get_attribute_options($collection);
        
        //Generates the combinations of customer choice options
        $combinations = (new CombinationService())->generate_combination($options);
        
        $variant = '';
        if (count($combinations) > 0) {
            $product->variant_product = 1;
            $product->save();
            foreach ($combinations as $key => $combination) {
                $str = ProductUtility::get_combination_string($combination, $collection);
                $product_stock = new ProductStock();
                $product_stock->product_id = $product->id;
                $product_stock->variant = $str;
                $product_stock->price = request()->get('price_' . str_replace('.', '_', $str));
                $product_stock->sku = request()->get('sku_' . str_replace('.', '_', $str));
                $product_stock->qty = request()->get('qty_' . str_replace('.', '_', $str));
                $product_stock->image = request()->get('img_' . str_replace('.', '_', $str));
                $product_stock->discount = request()->get('discount_' . str_replace('.', '_', $str), 0);        // Added
                $product_stock->discount_type = request()->get('discount_type_' . str_replace('.', '_', $str), 'amount'); // Added
                $product_stock->save();
            }
        } else {
            unset($collection['colors_active'], $collection['colors'], $collection['choice_no']);
            $qty = $collection['current_stock'];
            $price = $collection['unit_price'];
            $discount = $collection['discount'] ?? 0;           // Added
            $discount_type = $collection['discount_type'] ?? 'amount'; // Added
            unset($collection['current_stock']);

            $data = $collection->merge(compact('variant', 'qty', 'price', 'discount', 'discount_type'))->toArray();
            
            ProductStock::create($data);
        }
    }

    public function product_duplicate_store($product_stocks, $product_new)
    {
        foreach ($product_stocks as $key => $stock) {
            $product_stock = new ProductStock;
            $product_stock->product_id = $product_new->id;
            $product_stock->variant = $stock->variant;
            $product_stock->price = $stock->price;
            $product_stock->sku = $stock->sku;
            $product_stock->qty = $stock->qty;
            $product_stock->image = $stock->image;
            $product_stock->discount = $stock->discount ?? 0;          // Added
            $product_stock->discount_type = $stock->discount_type ?? 'amount'; // Added
            $product_stock->save();
        }
    }
}