@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('City Information') }}</h5>
    </div>

    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card">
                <div class="card-body p-0">
                    <ul class="nav nav-tabs nav-fill language-bar">
                        @foreach (get_all_active_language() as $key => $language)
                            <li class="nav-item">
                                <a class="nav-link text-reset @if ($language->code == $lang) active @endif py-3"
                                    href="{{ route('cities.edit', ['id' => $city->id, 'lang' => $language->code]) }}">
                                    <img src="{{ static_asset('assets/img/flags/' . $language->code . '.png') }}"
                                        height="11" class="mr-1">
                                    <span>{{ $language->name }}</span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                    <form id="city_form" class="p-4" action="{{ route('cities.update', $city->id) }}" method="POST"
                        enctype="multipart/form-data">
                        <input name="_method" type="hidden" value="PATCH">
                        <input type="hidden" name="lang" value="{{ $lang }}">
                        @csrf
                        <div class="form-group mb-3">
                            <label for="name">{{ translate('Name') }}</label>
                            <input type="text" placeholder="{{ translate('Name') }}"
                                value="{{ $city->getTranslation('name', $lang) }}" name="name" class="form-control"
                                required>
                        </div>

                        <div class="form-group">
                            <label for="state_id">{{ translate('State') }}</label>
                            <select class="select2 form-control aiz-selectpicker" name="state_id"
                                data-selected="{{ $city->state_id }}" data-toggle="select2" data-placeholder="Choose ..."
                                data-live-search="true" required>
                                @foreach ($states as $state)
                                    <option value="{{ $state->id }}">{{ $state->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group mb-3 pincodes">
                            <label for="pincodes">{{ translate('Pincodes') }}</label>
                            <select class="select2 form-control aiz-selectpicker" name="pincodes[]" id="pincodes" multiple
                                data-toggle="select2" data-placeholder="Type and press Enter" data-live-search="true">
                                @foreach ($city->pincodes as $pincode)
                                    <option value="{{ $pincode->pincode }}" selected>{{ $pincode->pincode }}</option>
                                @endforeach
                            </select>
                            <small class="form-text text-muted">{{ translate('Type pincode and press Enter to add multiple pincodes') }}</small>
                            <input type="text" id="pincodes_input" class="form-control" placeholder="Type and press Enter">
                        </div>

                        <div class="form-group mb-3">
                            <label for="name">{{ translate('Cost') }}</label>
                            <input type="number" min="0" step="0.01" placeholder="{{ translate('Cost') }}"
                                name="cost" class="form-control" value="{{ $city->cost }}" required>
                        </div>


                        <div class="form-group mb-3 text-right">
                            <button type="submit" class="btn btn-primary">{{ translate('Update') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#pincodes_input').on('keydown', function(e) {
                let pincodes_input = $(this).val();
                if (e.keyCode === 13 && pincodes_input != '') {
                    e.preventDefault();
                    $('#pincodes_input').val('');
                    if ($('#pincodes option[value="' + pincodes_input + '"]').length > 0) {
                        return false;
                    };
                    if ($('#pincodes').val() == '') {
                        $('#city_form .pincodes .filter-option-inner-inner').html(pincodes_input);
                    } else {
                        $('#city_form .pincodes .filter-option-inner-inner').append(', ' + pincodes_input);
                    }
                    $('#pincodes').append('<option value="' + pincodes_input + '" selected>' +
                        pincodes_input + '</option>');
                    $('#city_form .pincodes .inner .dropdown-menu').append(
                        `<li class="selected"><a role="option" class="dropdown-item selected" id="bs-select-2-0" tabindex="0" aria-selected="true" aria-setsize="3" aria-posinset="1"><span class=" bs-ok-default check-mark"></span><span class="text">${pincodes_input}</span></a></li>`
                    );
                }
                // return false;
            });
        });
    </script>
@endsection
