<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{ $subject ?? 'Email Verification' }}</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 620px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 10px;
            padding: 30px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
        }
        .header h2 {
            margin: 0;
            color: #0b60bd;
        }
        .content {
            font-size: 16px;
            color: #444;
            line-height: 1.6;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            background-color: #0b60bd;
            color: #ffffff;
            padding: 14px 28px;
            border-radius: 6px;
            text-decoration: none;
            display: inline-block;
            font-weight: bold;
        }
        .footer {
            font-size: 14px;
            color: #999;
            text-align: center;
            padding-top: 20px;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h2>{{ get_setting('site_name') }}</h2>
    </div>
    <div class="content">
        <p>Hello {{ $user->name }},</p>
        <p>Welcome to {{ get_setting('site_name') }}! Please verify your email address to complete your registration.</p>

        <div class="button-container">
            <a href="{{ $verification_link }}" class="btn" target="_blank">Verify Email</a>
        </div>

        <p>If you didn’t request this, you can safely ignore this email.</p>
        <p>Thanks,<br>The {{ get_setting('site_name') }} Team</p>
    </div>
    <div class="footer">
        This email was sent to {{ $user->email }}. If you have any questions, contact us at {{ get_admin()->email }}.
    </div>
</div>
</body>
</html>
