@extends('frontend.layouts.app')
<style>
    .product-card {
        transition: all 0.3s ease;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        overflow: hidden;
        height: 100%;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        border-color: #007bff;
        text-decoration: none;
    }

    .product-image {
        position: relative;
        overflow: hidden;
        height: 200px;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }

    .product-card:hover .product-image img {
        transform: scale(1.05);
    }

    .product-info {
        padding: 15px;
        text-align: center;
        background: white;
    }

    .product-name {
        font-size: 16px;
        font-weight: 700;
        color: #007bff;
        margin-bottom: 8px;
        min-height: 48px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .product-price {
        font-size: 18px;
        font-weight: 600;
        color: #28a745;
        margin-bottom: 5px;
    }

    .product-old-price {
        font-size: 14px;
        color: #6c757d;
        text-decoration: line-through;
        margin-bottom: 15px;
    }

    .view-btn {
        background: linear-gradient(45deg, #007bff, #0056b3);
        border: none;
        padding: 8px 20px;
        font-size: 14px;
        font-weight: 600;
        border-radius: 20px;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .view-btn:hover {
        background: linear-gradient(45deg, #0056b3, #004085);
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(0, 123, 255, 0.4);
    }

    .discount-badge {
        position: absolute;
        top: 10px;
        left: 10px;
        background: #dc3545;
        color: white;
        padding: 4px 8px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
        z-index: 1;
    }

    .product-card-wrapper {
        margin-bottom: 30px;
    }

    .hov-svg-white svg {
        margin-top: 10px;
    }
</style>
@section('content')
    <section class="pt-4 my-4">

        <div class="container">
            @php
                $todays_deal_products = filter_products(App\Models\Product::where('todays_deal', '1'))
                    ->orderBy('id', 'desc')
                    ->get();
            @endphp
            @if (count($todays_deal_products) > 0)
                <div class="col-12 col-lg-auto mt-4">
                    <div class="todays_deal bg-white rounded-2 overflow-hidden">
                        <div class="bg-soft-primary p-3 d-flex align-items-center justify-content-center">
                            <span class="fw-700 fs-18 mr-2 text-truncate">
                                {{ translate('Featured Products') }}
                            </span>
                        </div>
                        <div class="p-2">
                            <div class="row">
                                @if (count(get_featured_products()) > 0)
                                    @foreach (get_featured_products() as $key => $product)
                                        <div class="carousel-box position-relative px-3 has-transition hov-animate-outline">
                                            @include(
                                                'frontend.' .
                                                    get_setting('homepage_select') .
                                                    '.partials.product_box_1',
                                                ['product' => $product]
                                            )
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12">
                                        <div class="empty-section">
                                            <p class="text-muted">{{ translate('No featured products found') }}</p>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
@endsection
