@extends('frontend.layouts.app')
<style>
    .bs-searchbox .form-control {
        height: 31px;
    }

    .datalist {
        position: absolute;
        z-index: 999;
        width: 514px;
        max-height: 200px;
        overflow-y: auto;
        background: #fff;
        border: 1px solid #ccc;
        display: none;
    }

    .datalist ul {
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .datalist ul li {
        padding: 8px 12px;
        cursor: pointer;
    }

    .datalist ul li:hover {
        background-color: #f2f2f2;
    }

    @media(max-width: 776px) {
        .datalist {
            width: auto;
        }
    }
</style>
@section('content')
    <div class="checkout-page">
        <div class="container">
            <div class="checkout-wrapper">
                <!-- Billing Form -->
                <form class="form-default" data-toggle="validator" action="{{ route('payment.checkout') }}" role="form" method="POST" id="checkout-form">
                    @csrf
                    <input type="hidden" name="payment_option" id="bill-payment-type" />
                    <input type="hidden" name="country" id="country">
                    <input type="hidden" name="state" id="state">
                    <input type="hidden" name="city" id="city">
                    <input type="hidden" name="postal_code" id="postal_code">
                    <section class="section billing-form">
                        <a href="{{ route('cart') }}" class="back-btn">← Back</a>
                        <h2>Shipping Information</h2>
                        <input type="hidden" id="bill-longitude" name="longitude" />
                        <input type="hidden" id="bill-latitude" name="latitude" />
                        <div class="form-group">
                            <label for="name">Full Name *</label>
                            <input type="text" class="form-control" id="bill-name" name="name" placeholder="Enter your name" value="{{ old('name', auth()->check() ? auth()->user()->name : '') }}" required />
                        </div>
                        <div class="form-group">
                            <label for="email">Email *</label>
                            <input type="email" class="form-control" id="bill-email" name="email" placeholder="Enter your email" value="{{ old('email', auth()->check() ? auth()->user()->email : '') }}" required />
                        </div>
                        <div class="form-group">
                            <label for="phone">Mobile Number *</label>
                            <input type="text" class="form-control phone-code" id="bill-mobile" name="phone" placeholder="Enter your mobile number" value="{{ format_mobile(old('phone', auth()->check() ? auth()->user()->phone : ''), 91, true) }}" required />
                        </div>
                        <div class="form-group">
                            <label for="address">Address *</label>
                            <input type="text" class="form-control" name="address" id="bill-address" placeholder="Enter your address" value="{{ old('address', auth()->check() ? auth()->user()->address : '') }}" required />
                        </div>
                        <div class="form-group">
                            <label for="country">Country *</label>
                            <input type="text" class="form-control" name="countrydata" id="countrydata" placeholder="Search Country" autocomplete="off" aria-autocomplete="none">
                            <div class="countrylist datalist">
                                <ul class="list-group">
                                </ul>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="state">State *</label>
                            <input type="text" class="form-control" name="statedata" id="statedata" placeholder="Search State" autocomplete="off" aria-autocomplete="none" readonly>
                            <div class="statelist datalist">
                                <ul class="list-group">
                                </ul>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="city">City *</label>
                            <input type="text" class="form-control" name="citydata" id="citydata" placeholder="Search City" autocomplete="off" aria-autocomplete="none" readonly>
                            <div class="citylist datalist">
                                <ul class="list-group">
                                </ul>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="zip">PIN Code *</label>
                            <input type="text" class="form-control" name="pindata" id="pindata" placeholder="Search Pin Code" autocomplete="off" aria-autocomplete="none" readonly>
                            <div class="pinlist datalist">
                                <ul class="list-group">
                                </ul>
                            </div>
                        </div>
                    </section>
                </form>
                <!-- Order Summary -->
                <section id="order-summary-section">
                    @include('frontend.partials.cart.order-summary')
                </section>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        let appliedWallet = 0;
        var minimum_order_amount_check = {{ get_setting('minimum_order_amount_check') == 1 ? 1 : 0 }};
        var minimum_order_amount = {{ get_setting('minimum_order_amount_check') == 1 ? get_setting('minimum_order_amount') : 0 }};

        function updateQuantity($this, cartId, change) {
            $($this).prop('disabled', true);
            const quantityElement = $($this).closest('.product-item').find('.quantity-product');
            let quantity = parseInt(quantityElement.text());
            quantity = Math.max(0, quantity + change);
            quantityElement.text(quantity);

            updateCartProductQuantity(cartId, quantity)
        }

        function updateCartProductQuantity(cartId, quantity) {
            $.post("{{ route('cart.updateQuantity') }}", {
                _token: AIZ.data.csrf,
                id: cartId,
                quantity: quantity,
                payment_method: $('#payment_method').val(),
                wallet_used_amount: appliedWallet,
            }, function(data) {
                $('#order-summary-section').html(data.order_summary_view);
                const errorMessage = data?.message || "";
                if (errorMessage) {
                    AIZ.plugins.notify('danger', errorMessage);
                }
            });
        }

        function updateWallet() {
            const my_wallet = parseInt("{{ auth()->user()->balance }}");
            const walletInput = document.getElementById('wallet-amount');
            let walletValue = parseInt(walletInput.value) || 0;
            walletValue = Math.min(Math.max(walletValue, 0), 1000);
            if (my_wallet >= walletValue) {
                appliedWallet = walletValue;
                walletInput.value = walletValue;
            } else {
                appliedWallet = my_wallet;
                walletInput.value = my_wallet;
            }
        }

        function updatePaymentType($this) {
            $('#bill-payment-type').val($($this).val());
        }

        function submitOrder(el) {
            $(el).prop('disabled', true);
            if ($('#agree_checkbox').is(":checked")) {
                let subtotal = $('#subtotal').text();
                subtotal = parseFloat(subtotal.replace(/[^0-9.]/g, ""));
                if (minimum_order_amount_check && subtotal < minimum_order_amount) {
                    // alert(minimum_order_amount_check);
                    // alert(subtotal);
                    // alert(minimum_order_amount);
                    AIZ.plugins.notify('danger', "{{ translate('You order amount is less then the minimum order amount') }}");
                } else {
                    $('#checkout-form').submit();
                }
            } else {
                AIZ.plugins.notify('danger', '{{ translate('You need to agree with our policies') }}');
            }
            if ($('#agree_checkbox').is(':checked')) {
                $(el).prop('disabled', false);
            }
        }


        function agreeCheckbox($this) {
            $("#submitOrderBtn").prop('disabled', !$($this).is(':checked'));
        }

        // Coupon apply
        $(document).on("click", "#coupon-apply", function(e) {
            e.preventDefault();
            @if (Auth::check())
                @if (Auth::user()->user_type != 'customer')
                    AIZ.plugins.notify('warning', "{{ translate('Please Login as a customer to apply coupon code.') }}");
                    return false;
                @endif

                $.ajax({
                    method: "POST",
                    url: "{{ route('checkout.apply_coupon_code') }}",
                    data: {
                        _token: AIZ.data.csrf,
                        code: $('#coupon-code').val(),
                        payment_method: $('#payment_method').val(),
                        wallet_used_amount: appliedWallet,
                    },
                    success: function(data, textStatus, jqXHR) {
                        AIZ.plugins.notify(data.response_message.response, data.response_message.message);
                        $("#order-summary-section").html(data.html);
                    }
                });
            @else
                $('#login_modal').modal('show');
            @endif
        });

        // Coupon remove
        $(document).on("click", "#coupon-remove", function() {
            @if (Auth::check() && Auth::user()->user_type == 'customer')
                var data = new FormData($('#remove-coupon-form')[0]);
                $.ajax({
                    method: "POST",
                    url: "{{ route('checkout.remove_coupon_code') }}",
                    data: {
                        _token: AIZ.data.csrf,
                        payment_method: $('#payment_method').val(),
                        wallet_used_amount: appliedWallet,
                    },
                    success: function(data, textStatus, jqXHR) {
                        AIZ.plugins.notify(data.response_message.response, data.response_message.message);
                        $("#order-summary-section").html(data.html);
                    }
                });
            @endif
        });

        function changeSelectValueWithOption(select, matchText) {
            $(select + ' option').each(function() {
                if ($(this).text().trim() === matchText) {
                    $(this).prop('selected', true);
                    return false;
                }
            });
        }


        let c = null;

        $(document).on('input', '#countrydata', function() {
            clearTimeout(c);

            c = setTimeout(() => {
                let text = $(this).val().trim();
                $('.countrylist ul').empty();

                if (text.length === 0) {
                    $('.countrylist').css('display', 'none');
                    return;
                }

                $.ajax({
                    type: 'POST',
                    url: '{{ route('countryfetch') }}',
                    data: {
                        text: text,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.length > 0) {
                            $('.countrylist').css('display', 'block');
                            let li = '';
                            response.forEach((dt) => {
                                li += `<li class="list-group-item countryitem" data-code="${dt.id}">${dt.name}</li>`;
                            });
                            $('.countrylist ul').append(li);
                        } else {
                            $('.countrylist').css('display', 'block');
                            $('.countrylist ul').html('<li class="list-group-item text-muted">No countries found</li>');
                        }
                    },
                    error: function() {
                        $('.countrylist').css('display', 'block');
                        $('.countrylist ul').html('<li class="list-group-item text-danger">Error loading countries</li>');
                    }
                });
            }, 400);
        });

        $(document).on('click', '.countryitem', function() {
            let code = $(this).data('code');
            let name = $(this).text();
            $('#country').val(code);
            $('#countrydata').val(name);
            $('.countrylist').css('display', 'none');
            $('#statedata').prop('readonly', false);
        });

        $(document).on('input', '#statedata', function() {
            clearTimeout(c);
            let countrycode = $('#country').val().trim();

            if (countrycode == '') {
                AIZ.plugins.notify('error', 'Country Not Found');
            }

            c = setTimeout(() => {
                let text = $(this).val().trim();
                $('.statelist ul').empty();

                if (text.length === 0) {
                    $('.statelist').css('display', 'none');
                    return;
                }

                $.ajax({
                    type: 'POST',
                    url: '{{ route('statefetch') }}',
                    data: {
                        text: text,
                        countrycode: countrycode,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.length > 0) {
                            $('.statelist').css('display', 'block');
                            let li = '';
                            response.forEach((dt) => {
                                li += `<li class="list-group-item stateitem" data-code="${dt.id}">${dt.name}</li>`;
                            });
                            $('.statelist ul').append(li);
                        } else {
                            $('.statelist').css('display', 'block');
                            $('.statelist ul').html('<li class="list-group-item text-muted">No States found</li>');
                        }
                    },
                    error: function() {
                        $('.statelist').css('display', 'block');
                        $('.statelist ul').html('<li class="list-group-item text-danger">Error loading States</li>');
                    }
                });
            }, 400);
        });

        $(document).on('click', '.stateitem', function() {
            let code = $(this).data('code');
            let name = $(this).text();
            $('#state').val(code);
            $('#statedata').val(name);
            $('.statelist').css('display', 'none');
            $('#citydata').prop('readonly', false);
        });

        $(document).on('input', '#citydata', function() {
            clearTimeout(c);
            let statecode = $('#state').val().trim();

            if (statecode == '') {
                AIZ.plugins.notify('error', 'State Not Found');
            }

            c = setTimeout(() => {
                let text = $(this).val().trim();
                $('.citylist ul').empty();

                if (text.length === 0) {
                    $('.citylist').css('display', 'none');
                    return;
                }

                $.ajax({
                    type: 'POST',
                    url: '{{ route('cityfetch') }}',
                    data: {
                        text: text,
                        statecode: statecode,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.length > 0) {
                            $('.citylist').css('display', 'block');
                            let li = '';
                            response.forEach((dt) => {
                                li += `<li class="list-group-item cityitem" data-code="${dt.id}">${dt.name}</li>`;
                            });
                            $('.citylist ul').append(li);
                        } else {
                            $('.citylist').css('display', 'block');
                            $('.citylist ul').html('<li class="list-group-item text-muted">No City found</li>');
                        }
                    },
                    error: function() {
                        $('.citylist').css('display', 'block');
                        $('.citylist ul').html('<li class="list-group-item text-danger">Error loading City</li>');
                    }
                });
            }, 400);
        });

        $(document).on('click', '.cityitem', function() {
            let code = $(this).data('code');
            let name = $(this).text();
            $('#city').val(code);
            $('#citydata').val(name);
            $('.citylist').css('display', 'none');
            $('#pindata').prop('readonly', false);

            if (code != '') {
                $.ajax({
                    type: 'POST',
                    url: '{{ route('pinfetch') }}',
                    data: {
                        citycode: code,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.length > 0) {
                            $('.pinlist').css('display', 'block');
                            let li = '';
                            response.forEach((dt) => {
                                li += `<li class="list-group-item pinitem" data-code="${dt.pincode}">${dt.pincode}</li>`;
                            });
                            $('.pinlist ul').empty();
                            $('#pindata').val('');
                            $('#postal_code').val('');
                            $('.pinlist ul').append(li);
                        } else {
                            $('.pinlist').css('display', 'block');
                            $('.pinlist ul').html('<li class="list-group-item text-muted">No Pin found</li>');
                        }
                    },
                    error: function() {
                        $('.pinlist').css('display', 'block');
                        $('.pinlist ul').html('<li class="list-group-item text-danger">Error loading Pin</li>');
                    }
                });
            }
        });

        $(document).on('click', '.pinitem', function() {
            let code = $(this).data('code');
            $('#pindata').val(code);
            $('#postal_code').val(code);
            $('.pinlist').css('display', 'none');
        });

        function autofillHiddenInput(inputId, hiddenId, route, parentKey = null, parentValue = null) {
            const inputVal = $(inputId).val().trim();
            if (!inputVal) return;

            let requestData = {
                text: inputVal,
                _token: "{{ csrf_token() }}"
            };

            if (parentKey && parentValue) {
                requestData[parentKey] = parentValue;
            }

            $.post(route, requestData, function(response) {
                if (response.length === 1 && response[0].name.toLowerCase() === inputVal.toLowerCase()) {
                    $(hiddenId).val(response[0].id);
                }
            });
        }

        $('#countrydata').on('blur', function() {
            if (!$('#country').val()) {
                autofillHiddenInput('#countrydata', '#country', '{{ route('countryfetch') }}');
            }
        });

        $('#statedata').on('blur', function() {
            if (!$('#state').val()) {
                const countryCode = $('#country').val();
                if (countryCode) {
                    autofillHiddenInput('#statedata', '#state', '{{ route('statefetch') }}', 'countrycode', countryCode);
                }
            }
        });

        $('#citydata').on('blur', function() {
            if (!$('#city').val()) {
                const stateCode = $('#state').val();
                if (stateCode) {
                    autofillHiddenInput('#citydata', '#city', '{{ route('cityfetch') }}', 'statecode', stateCode);
                }
            }
        });
    </script>
@endsection
