@extends('frontend.layouts.app')

@section('content')
    <section class="my-4 gry-bg">
        <div class="container">
            <div class="row cols-xs-space cols-sm-space cols-md-space">
                <div class="col-lg-1"></div>
                <div class="col-lg-7">
                    <div class="card pt-2">
                        <div class="card-header" style="border-bottom: none;padding-top: 10px;padding-bottom: 0px;">
                            <h4>{{ translate('Shipping Details') }}</h4>
                        </div>
                        <div class="card-body">
                            <button type="button" id="fetchCurrentLocationLoadingBtn" class="btn btn-primary btn-sm mb-3" style="width:110px;display:none;">
                                <div class="loading-text">
                                    Loading
                                    <div class="dots">
                                        <span>.</span>
                                        <span>.</span>
                                        <span>.</span>
                                    </div>
                                </div>
                            </button>
                            <button type="button" id="fetchCurrentLocationBtn" class="btn btn-primary btn-sm mb-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" class="da7+UC"><g fill="none" fill-rule="evenodd"><path d="M0 0h16v16H0z"></path><path class="" fill="#fff" d="M8 5.3a2.7 2.7 0 1 0 0 5.4 2.7 2.7 0 1 0 0-5.4zm6 2A6 6 0 0 0 8.7 2V.7H7.3V2A6 6 0 0 0 2 7.3H.7v1.4H2A6 6 0 0 0 7.3 14v1.3h1.4V14A6 6 0 0 0 14 8.7h1.3V7.3H14zm-6 5.4A4.7 4.7 0 0 1 3.3 8 4.7 4.7 0 0 1 8 3.3 4.7 4.7 0 0 1 12.7 8 4.7 4.7 0 0 1 8 12.7z"></path></g></svg>
                                Use my current location
                            </button>
                            <form class="form-default" data-toggle="validator" action="{{ route('payment.checkout') }}" role="form" method="POST" id="checkout-form">
                            @csrf
                                <div class="form-group">
                                    <input type="text" class="form-control" id="bill-name" name="name" placeholder="Full Name *" value="{{ auth()->user()->name }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="email" class="form-control" id="bill-email"  name="email"placeholder="Email *" value="{{ auth()->user()->email }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control phone-code" id="bill-mobile" name="phone" placeholder="Mobile Number *" value="{{ format_mobile(auth()->user()->phone, 91, true) }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="address" id="bill-address" placeholder="Address *" value="{{ auth()->user()->address }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" name="country" id="bill-country" name="country" placeholder="Country *" value="{{ auth()->user()->country }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" id="bill-state" placeholder="State *" name="state" value="{{ auth()->user()->state }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" id="bill-city" placeholder="City *" name="city" value="{{ auth()->user()->city }}" required />
                                </div>
                                <div class="form-group">
                                    <input type="text" class="form-control" id="bill-pincode" placeholder="PIN Code *" name="postal_code" value="{{ auth()->user()->postal_code }}" required />
                                </div>
                                <input type="hidden" id="bill-longitude" name="longitude" />
                                <input type="hidden" id="bill-latitude" name="latitude" />
                        

                                <div class="accordion" id="accordioncCheckoutInfo">

                                    <!-- Shipping Info -->
                                    <div class="card rounded-0 border shadow-none" style="margin-bottom: 2rem;">
                                        <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingShippingInfo" type="button" data-toggle="collapse" data-target="#collapseShippingInfo" aria-expanded="true" aria-controls="collapseShippingInfo">
                                            <div class="d-flex align-items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                                    <path id="Path_42357" data-name="Path 42357" d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z" transform="translate(-48 -48)" fill="#9d9da6"/>
                                                </svg>
                                                <span class="ml-2 fs-19 fw-700">{{ translate('Shipping Info') }}</span>
                                            </div>
                                            <i class="las la-angle-down fs-18"></i>
                                        </div>
                                        <div id="collapseShippingInfo" class="collapse show" aria-labelledby="headingShippingInfo" data-parent="#accordioncCheckoutInfo">
                                            <div class="card-body" id="shipping_info">
                                               @include('frontend.partials.cart.shipping_info', ['address_id' => $address_id])
                                            </div>
                                        </div>
                                    </div>
        
                                    <!-- Delivery Info -->
                                    <div class="card rounded-0 border shadow-none" style="margin-bottom: 2rem; overflow: visible !important;">
                                        <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingDeliveryInfo" type="button" data-toggle="collapse" data-target="#collapseDeliveryInfo" aria-expanded="true" aria-controls="collapseDeliveryInfo">
                                            <div class="d-flex align-items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                                    <path id="Path_42357" data-name="Path 42357" d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z" transform="translate(-48 -48)" fill="#9d9da6"/>
                                                </svg>
                                                <span class="ml-2 fs-19 fw-700">{{ translate('Delivery Info') }}</span>
                                            </div>
                                            <i class="las la-angle-down fs-18"></i>
                                        </div>
                                        <div id="collapseDeliveryInfo" class="collapse show" aria-labelledby="headingDeliveryInfo" data-parent="#accordioncCheckoutInfo">
                                            <div class="card-body" id="delivery_info">
                                                @include('frontend.partials.cart.delivery_info', ['carts' => $carts, 'carrier_list' => $carrier_list, 'shipping_info' => $shipping_info])
                                            </div>
                                        </div>
                                    </div>
        
        
                                    <!-- Payment Info -->
                                    <div class="card rounded-0 mb-0 border shadow-none">
                                        <div class="card-header border-bottom-0 py-3 py-xl-4" id="headingPaymentInfo" type="button" data-toggle="collapse" data-target="#collapsePaymentInfo" aria-expanded="true" aria-controls="collapsePaymentInfo">
                                            <div class="d-flex align-items-center">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">
                                                    <path id="Path_42357" data-name="Path 42357" d="M58,48A10,10,0,1,0,68,58,10,10,0,0,0,58,48ZM56.457,61.543a.663.663,0,0,1-.423.212.693.693,0,0,1-.428-.216l-2.692-2.692.856-.856,2.269,2.269,6-6.043.841.87Z" transform="translate(-48 -48)" fill="#9d9da6"/>
                                                </svg>
                                                <span class="ml-2 fs-19 fw-700">{{ translate('Payment') }}</span>
                                            </div>
                                            <i class="las la-angle-down fs-18"></i>
                                        </div>
                                        <div id="collapsePaymentInfo" class="collapse show" aria-labelledby="headingPaymentInfo" data-parent="#accordioncCheckoutInfo">
                                            <div class="card-body" id="payment_info">
                                                @include('frontend.partials.cart.payment_info', ['carts' => $carts, 'total' => $total])
        
                                                
        
                                                <!--<div class="row align-items-center pt-3 mb-4">-->
                                                    <!-- Return to shop -->
                                                <!--    <div class="col-6">-->
                                                <!--        <a href="{{ route('home') }}" class="btn btn-link fs-14 fw-700 px-0">-->
                                                <!--            <i class="las la-arrow-left fs-16"></i>-->
                                                <!--            {{ translate('Return to shop') }}-->
                                                <!--        </a>-->
                                                <!--    </div>-->
                                                    <!-- Complete Ordert -->
                                                <!--    <div class="col-6 text-right">-->
                                                <!--        <button type="button" onclick="submitOrder(this)" id="submitOrderBtn"-->
                                                <!--            class="btn btn-primary fs-14 fw-700 rounded-0 px-4">{{ translate('Complete Order') }}</button>-->
                                                <!--    </div>-->
                                                <!--</div>-->
        
                                            </div>
                                        </div>
                                    </div>
        
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- Cart Summary -->
                <div class="col-lg-4" id="cart_summary">
                    @include('frontend.partials.cart.cart_summary', ['proceed' => 0, 'carts' => $carts])
                </div>
            </div>
        </div>
    </section>
@endsection

@section('modal')
    <!-- Address Modal -->
    @if(Auth::check())
        @include('frontend.partials.address.address_modal')
    @endif
@endsection

@section('script')
    <script type="text/javascript">
        $(document).ready(function() {
            $(".online_payment").click(function() {
                $('#manual_payment_description').parent().addClass('d-none');
            });
            toggleManualPaymentData($('input[name=payment_option]:checked').data('id'));

            // Initial population of pincodes for guest checkout if city is pre-selected
            var initialCityId = $('select[name="city_id"]').val();
            if (initialCityId) {
                updatePincodes(initialCityId, 'pincode_select');
            }
        });

        // Function to fetch user's location and populate billing address
        document.getElementById('fetchCurrentLocationBtn').addEventListener('click', function () {
            if (navigator.geolocation) {
                const $this = this;
                const loadingBtn = document.getElementById('fetchCurrentLocationLoadingBtn');
                loadingBtn.style.display = "block";
                $this.style.display = "none";
                navigator.geolocation.getCurrentPosition(
                    function (position) {
                        const latitude = position.coords.latitude;
                        const longitude = position.coords.longitude;
                        document.getElementById('bill-latitude').value = latitude;
                        document.getElementById('bill-longitude').value = longitude;

                        // Use Nominatim API for reverse geocoding
                        fetch(`https://nominatim.openstreetmap.org/reverse?lat=${latitude}&lon=${longitude}&format=json`)
                            .then(response => response.json())
                            .then(data => {
                                loadingBtn.style.display = "none";
                                $this.style.display = "block";
                                if (data && data.address && Object.keys(data.address).length) {
                                    // Populate the billing address field with the fetched address
                                    document.getElementById('bill-address').value = data.address.road;
                                    document.getElementById('bill-country').value = data.address.country;
                                    document.getElementById('bill-state').value = data.address.state;
                                    document.getElementById('bill-city').value = data.address.city;
                                    document.getElementById('bill-pincode').value = data.address.postcode;
                                } else {
                                    alert('Unable to fetch address. Please enter manually.');
                                }
                            })
                            .catch(error => {
                                loadingBtn.style.display = "none";
                                $this.style.display = "block";
                                console.error('Error fetching address:', error);
                                alert('Error fetching address. Please try again.');
                            });
                    },
                    function (error) {
                        loadingBtn.style.display = "none";
                        $this.style.display = "block";
                        alert(error.message, 'error')
                        // Handle geolocation errors
                        switch (error.code) {
                            case error.PERMISSION_DENIED:
                                alert('Location access denied. Please allow location access or enter the address manually.');
                                break;
                            case error.POSITION_UNAVAILABLE:
                                alert('Location information is unavailable.');
                                break;
                            case error.TIMEOUT:
                                alert('The request to get your location timed out.');
                                break;
                            default:
                                alert('An unknown error occurred.');
                                break;
                        }
                    }
                );
            } else {
                alert('Geolocation is not supported by your browser.');
            }
        });

        var minimum_order_amount_check = {{ get_setting('minimum_order_amount_check') == 1 ? 1 : 0 }};
        var minimum_order_amount = {{ get_setting('minimum_order_amount_check') == 1 ? get_setting('minimum_order_amount') : 0 }};

        function use_wallet() {
            $('input[name=payment_option]').val('wallet');
            if ($('#agree_checkbox').is(":checked")) {
                if (minimum_order_amount_check && $('#sub_total').val() < minimum_order_amount) {
                    AIZ.plugins.notify('danger', '{{ translate('You order amount is less then the minimum order amount') }}');
                } else {
                    var allIsOk = false;
                    var isOkShipping = stepCompletionShippingInfo();
                    var isOkDelivery = stepCompletionDeliveryInfo();
                    var isOkPayment = stepCompletionWalletPaymentInfo();
                    var isOkBilling = billingFormCompleted();
                    if (isOkShipping && isOkDelivery && isOkPayment && isOkBilling) {
                        allIsOk = true;
                    } else {
                        AIZ.plugins.notify('danger', '{{ translate("Please fill in all mandatory fields!") }}');
                        $('#checkout-form [required]').each(function (i, el) {
                            if ($(el).val() == '' || $(el).val() == undefined) {
                                var is_trx_id = $('.d-none #trx_id').length;
                                if (($(el).attr('name') != 'trx_id') || is_trx_id == 0) {
                                    $(el).focus();
                                    $(el).scrollIntoView({ behavior: "smooth", block: "center" });
                                    return false;
                                }
                            }
                        });
                    }

                    if (allIsOk) {
                        $('#checkout-form').submit();
                    }
                }
            } else {
                AIZ.plugins.notify('danger', '{{ translate('You need to agree with our policies') }}');
            }
        }

        function submitOrder(el) {
            $(el).prop('disabled', true);
            if ($('#agree_checkbox').is(":checked")) {
                if (minimum_order_amount_check && $('#sub_total').val() < minimum_order_amount) {
                    AIZ.plugins.notify('danger', '{{ translate('You order amount is less then the minimum order amount') }}');
                } else {
                    var offline_payment_active = '{{ addon_is_activated('offline_payment') }}';
                    if (offline_payment_active == '1' && $('.offline_payment_option').is(":checked") && $('#trx_id').val() == '') {
                        AIZ.plugins.notify('danger', '{{ translate('You need to put Transaction id') }}');
                        $(el).prop('disabled', false);
                    } else {
                        var allIsOk = false;
                        var isOkShipping = stepCompletionShippingInfo();
                        var isOkDelivery = stepCompletionDeliveryInfo();
                        var isOkPayment = stepCompletionPaymentInfo();
                        var isOkBilling = billingFormCompleted();
                        if (isOkShipping && isOkDelivery && isOkPayment && isOkPayment) {
                            allIsOk = true;
                        } else {
                            AIZ.plugins.notify('danger', '{{ translate("Please fill in all mandatory fields!") }}');
                            $('#checkout-form [required]').each(function (i, el) {
                                if ($(el).val() == '' || $(el).val() == undefined) {
                                    var is_trx_id = $('.d-none #trx_id').length;
                                    if (($(el).attr('name') != 'trx_id') || is_trx_id == 0) {
                                        $(el).focus();
                                        $(el).scrollIntoView({ behavior: "smooth", block: "center" });
                                        return false;
                                    }
                                }
                            });
                        }

                        if (allIsOk) {
                            $('#checkout-form').submit();
                        }
                    }
                }
            } else {
                AIZ.plugins.notify('danger', '{{ translate('You need to agree with our policies') }}');
                $(el).prop('disabled', false);
            }
        }

        function toggleManualPaymentData(id) {
            if (typeof id != 'undefined') {
                $('#manual_payment_description').parent().removeClass('d-none');
                $('#manual_payment_description').html($('#manual_payment_info_' + id).html());
            }
        }

        // Coupon apply
        $(document).on("click", "#coupon-apply", function() {
            @if (Auth::check())
                @if(Auth::user()->user_type != 'customer')
                    AIZ.plugins.notify('warning', "{{ translate('Please Login as a customer to apply coupon code.') }}");
                    return false;
                @endif
                var data = new FormData($('#apply-coupon-form')[0]);
                $.ajax({
                    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                    method: "POST",
                    url: "{{ route('checkout.apply_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        AIZ.plugins.notify(data.response_message.response, data.response_message.message);
                        $("#cart_summary").html(data.html);
                    }
                });
            @else
                $('#login_modal').modal('show');
            @endif
        });

        // Coupon remove
        $(document).on("click", "#coupon-remove", function() {
            @if (Auth::check() && Auth::user()->user_type == 'customer')
                var data = new FormData($('#remove-coupon-form')[0]);
                $.ajax({
                    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                    method: "POST",
                    url: "{{ route('checkout.remove_coupon_code') }}",
                    data: data,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(data, textStatus, jqXHR) {
                        $("#cart_summary").html(data);
                    }
                });
            @endif
        });

        function updateDeliveryAddress(id, city_id = 0) {
            $('.aiz-refresh').addClass('active');
            $.post('{{ route('checkout.updateDeliveryAddress') }}', {
                _token: AIZ.data.csrf,
                address_id: id,
                city_id: city_id
            }, function(data) {
                $('#delivery_info').html(data.delivery_info);
                $('#cart_summary').html(data.cart_summary);
                $('.aiz-refresh').removeClass('active');
            });
            AIZ.plugins.bootstrapSelect("refresh");
        }

        function stepCompletionShippingInfo() {
            var headColor = '#9d9da6';
            var btnDisable = true;
            var allOk = false;
            @if (Auth::check())
                var length = $('input[name="address_id"]:checked').length;
                if (length > 0) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            @else
                var count = 0;
                var length = $('#shipping_info [required]').length;
                $('#shipping_info [required]').each(function (i, el) {
                    if ($(el).val() != '' && $(el).val() != undefined && $(el).val() != null) {
                        count += 1;
                    }
                });
                if (count == length) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            @endif
            $('#headingShippingInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        $('#shipping_info [required]').each(function (i, el) {
            $(el).change(function() {
                if ($(el).attr('name') == 'address_id') {
                    updateDeliveryAddress($(el).val());
                }
                @if (get_setting('shipping_type') == 'area_wise_shipping')
                    if ($(el).attr('name') == 'city_id') {
                        let country_id = $('select[name="country_id"]').val();
                        let city_id = $(this).val();
                        updateDeliveryAddress(country_id, city_id);
                        updatePincodes(city_id, 'pincode_select');
                    }
                @endif
                stepCompletionShippingInfo();
            });
        });

        function stepCompletionDeliveryInfo() {
            var headColor = '#9d9da6';
            var btnDisable = true;
            var allOk = false;
            var content = $('#delivery_info [required]');
            if (content.length > 0) {
                var content_checked = $('#delivery_info [required]:checked');
                if (content_checked.length > 0) {
                    content_checked.each(function (i, el) {
                        allOk = false;
                        if ($(el).val() == 'carrier') {
                            var owner = $(el).attr('data-owner');
                            if ($('input[name=carrier_id_' + owner + ']:checked').length > 0) {
                                allOk = true;
                            }
                        } else if ($(el).val() == 'pickup_point') {
                            var owner = $(el).attr('data-owner');
                            if ($('select[name=pickup_point_id_' + owner + ']').val() != '') {
                                allOk = true;
                            }
                        } else {
                            allOk = true;
                        }
                        if (allOk == false) {
                            return false;
                        }
                    });
                    if (allOk) {
                        headColor = '#15a405';
                        btnDisable = false;
                    }
                }
            } else {
                allOk = true;
                headColor = '#15a405';
                btnDisable = false;
            }
            $('#headingDeliveryInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        function updateDeliveryInfo(shipping_type, type_id, user_id, country_id = 0, city_id = 0) {
            @if (get_setting('shipping_type') == 'area_wise_shipping' || get_setting('shipping_type') == 'carrier_wise_shipping')
                country_id = $('select[name="country_id"]').val() != null ? $('select[name="country_id"]').val() : 0;
                city_id = $('select[name="city_id"]').val() != null ? $('select[name="city_id"]').val() : 0;
            @endif
            $('.aiz-refresh').addClass('active');
            $.post('{{ route('checkout.updateDeliveryInfo') }}', {
                _token: AIZ.data.csrf,
                shipping_type: shipping_type,
                type_id: type_id,
                user_id: user_id,
                country_id: country_id,
                city_id: city_id
            }, function(data) {
                $('#cart_summary').html(data);
                stepCompletionDeliveryInfo();
                $('.aiz-refresh').removeClass('active');
            });
            AIZ.plugins.bootstrapSelect("refresh");
        }

        function show_pickup_point(el, user_id) {
            var type = $(el).val();
            var target = $(el).data('target');
            var type_id = null;
            if (type == 'home_delivery' || type == 'carrier') {
                if (!$(target).hasClass('d-none')) {
                    $(target).addClass('d-none');
                }
                $('.carrier_id_' + user_id).removeClass('d-none');
            } else {
                $(target).removeClass('d-none');
                $('.carrier_id_' + user_id).addClass('d-none');
            }
            if (type == 'carrier') {
                type_id = $('input[name=carrier_id_' + user_id + ']:checked').val();
            } else if (type == 'pickup_point') {
                type_id = $('select[name=pickup_point_id_' + user_id + ']').val();
            }
            updateDeliveryInfo(type, type_id, user_id);
        }

        function stepCompletionPaymentInfo() {
            var headColor = '#9d9da6';
            var btnDisable = true;
            var payment = false;
            var agree = false;
            var allOk = false;
            var length = $('input[name="payment_option"]:checked').length;
            if (length > 0) {
                if ($('input[name="payment_option"]:checked').hasClass('offline_payment_option')) {
                    if ($('#trx_id').val() != '' && $('#trx_id').val() != undefined && $('#trx_id').val() != null) {
                        payment = true;
                    }
                } else {
                    payment = true;
                }
                if ($('#agree_checkbox').is(":checked")) {
                    agree = true;
                }
                if (payment && agree) {
                    headColor = '#15a405';
                    btnDisable = false;
                    allOk = true;
                }
            }
            $('#headingPaymentInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        function stepCompletionWalletPaymentInfo() {
            var headColor = '#9d9da6';
            var btnDisable = true;
            var allOk = false;
            if ($('#agree_checkbox').is(":checked")) {
                headColor = '#15a405';
                btnDisable = false;
                allOk = true;
            }
            $('#headingPaymentInfo svg *').css('fill', headColor);
            $("#submitOrderBtn").prop('disabled', btnDisable);
            return allOk;
        }

        $('input[name="payment_option"]').change(function() {
            stepCompletionPaymentInfo();
        });

        // Function to update pincodes dynamically
        function updatePincodes(cityId, targetSelectId = 'pincode_select') {
            $.ajax({
                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                method: "POST",
                url: "{{ route('get_pincodes_by_city') }}",
                data: { city_id: cityId },
                success: function(response) {
                    var pincodeSelect = $('#' + targetSelectId);
                    pincodeSelect.empty();
                    pincodeSelect.append('<option value="">{{ translate('Select Pincode') }}</option>');
                    if (response.pincodes.length > 0) {
                        $.each(response.pincodes, function(index, pincode) {
                            pincodeSelect.append('<option value="' + pincode.pincode + '">' + pincode.pincode + '</option>');
                        });
                    } else {
                        pincodeSelect.append('<option value="">{{ translate('No Pincodes Available') }}</option>');
                    }
                    pincodeSelect.selectpicker('refresh');
                    stepCompletionShippingInfo();
                }
            });
        }

        function billingFormCompleted () {
            let allOk = true;
            const bill_attrs = ['name', 'email', 'mobile', 'address', 'country', 'state', 'city', 'pincode'];
            bill_attrs.forEach(attr => {
                $('#bill-'+attr).removeClass('is-valid');
                $('#bill-'+attr).closest('.form-group').find('.valid-feedback').remove();
                if(!$('#bill-'+attr).val()) {
                    allOk = false;
                    $('#bill-'+attr).closest('.form-group').append(`
                        <span class="valid-feedback">${attr} is required</span>
                    `);
                    $('#bill-'+attr).addClass('is-valid');
                }
                
            });
            $("#submitOrderBtn").prop('disabled', !allOk);
            return allOk;
        }

        $(document).ready(function() {
            stepCompletionShippingInfo();
            stepCompletionDeliveryInfo();
            stepCompletionPaymentInfo();
        });
        
    </script>

    @include('frontend.partials.address.address_js')

    @if (get_setting('google_map') == 1)
        @include('frontend.partials.google_map')
    @endif
@endsection
