{{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
<!-- Font Awesome Icons with latest version -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
<!-- Google Fonts - Poppins for modern look -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<style>
    /* Futuristic Design System with Enhanced Features */
    main {
        flex: 1;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
    }

    /* Neon Accents and Glowing Effects */
    .glow-text {
        text-shadow: 0 0 10px rgba(44, 160, 185, 0.5), 0 0 20px rgba(44, 160, 185, 0.3);
    }

    .neon-border {
        border: 2px solid transparent;
        background-clip: padding-box;
        box-shadow: 0 0 15px rgba(44, 160, 185, 0.5);
        backdrop-filter: blur(5px);
    }

    /* Enhanced Stats Section */
    .stats-section {
        background: linear-gradient(120deg, #ffffff 0%, #f8f9fa 100%);
        padding: 50px 0;
        text-align: center;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        position: relative;
        overflow: hidden;
        z-index: 1;
    }

    .stats-section::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent 48%, rgba(44, 160, 185, 0.2) 50%, transparent 52%);
        background-size: 200% 200%;
        animation: shimmer 5s infinite linear;
        z-index: -1;
    }

    @keyframes shimmer {
        0% {
            background-position: 200% 0;
        }

        100% {
            background-position: -200% 0;
        }
    }

    .stat-icon {
        width: 90px;
        height: 90px;
        margin-bottom: 25px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: #ffffff;
        border-radius: 50%;
        box-shadow: 0 10px 25px rgba(44, 160, 185, 0.2), inset 0 0 10px rgba(44, 160, 185, 0.1);
        position: relative;
        transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        animation: float 6s infinite ease-in-out;
    }

    .stat-icon::after {
        content: '';
        position: absolute;
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.8) 0%, rgba(255, 255, 255, 0.2) 100%);
        z-index: 0;
    }

    .stat-icon img {
        position: relative;
        z-index: 1;
        width: 50px;
        height: 50px;
        filter: drop-shadow(0 5px 15px rgba(44, 160, 185, 0.5));
        transition: all 0.3s ease;
    }

    .stat-icon:hover {
        transform: scale(1.15) rotate(10deg);
        box-shadow: 0 15px 35px rgba(44, 160, 185, 0.3), inset 0 0 15px rgba(44, 160, 185, 0.2);
    }

    .stat-icon:hover img {
        filter: drop-shadow(0 0 15px rgba(44, 160, 185, 0.8));
        transform: scale(1.1);
    }

    @keyframes float {

        0%,
        100% {
            transform: translateY(0);
        }

        50% {
            transform: translateY(-15px);
        }
    }

    .stat-number {
        font-size: clamp(2rem, 3vw, 3rem);
        font-weight: 800;
        background: linear-gradient(120deg, #2ca0b9 0%, #1a6f82 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 10px;
        position: relative;
        display: inline-block;
        transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        text-shadow: 3px 3px 6px rgba(0, 0, 0, 0.1);
        letter-spacing: 1px;
    }

    .stat-number::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 50%;
        transform: translateX(-50%);
        width: 0;
        height: 3px;
        background: linear-gradient(90deg, #2ca0b9, #4ecae5);
        transition: width 0.3s ease;
    }

    .stat-item:hover .stat-number::after {
        width: 70%;
    }

    .stat-number:hover {
        transform: scale(1.08);
        letter-spacing: 2px;
    }

    .stat-text {
        font-size: 16px;
        color: #333;
        font-weight: 500;
        transition: all 0.3s ease;
        opacity: 0.8;
    }

    .stat-item:hover .stat-text {
        opacity: 1;
        transform: translateY(3px);
        color: #1a6f82;
    }

    /* Futuristic Hover Card Effects */
    .stat-item {
        padding: 30px 20px;
        border-radius: 20px;
        transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        background: rgba(255, 255, 255, 0.8);
        backdrop-filter: blur(10px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.05);
        position: relative;
        z-index: 1;
        overflow: hidden;
    }

    .stat-item::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(44, 160, 185, 0.1) 0%, rgba(44, 160, 185, 0.05) 100%);
        z-index: -1;
        opacity: 0;
        transition: opacity 0.5s ease;
    }

    .stat-item:hover {
        transform: translateY(-15px);
        box-shadow: 0 20px 40px rgba(44, 160, 185, 0.2);
    }

    .stat-item:hover::before {
        opacity: 1;
    }

    /* Enhanced Company Info */
    .company-info {
        padding: 50px 0;
        border-top: 1px solid rgba(238, 238, 238, 0.5);
        border-bottom: 1px solid rgba(238, 238, 238, 0.5);
        position: relative;
        overflow: hidden;
    }

    .company-info::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(44, 160, 185, 0.05) 0%, rgba(44, 160, 185, 0.01) 100%);
        z-index: -1;
    }

    .company-logo {
        max-width: 220px;
        margin-bottom: 20px;
        transition: transform 0.5s ease;
        filter: drop-shadow(0 5px 15px rgba(0, 0, 0, 0.1));
    }

    .company-logo:hover {
        transform: scale(1.05);
    }

    .company-description {
        color: #555;
        font-size: 16px;
        line-height: 1.8;
        max-width: 800px;
        margin: 0 auto;
        position: relative;
        padding: 10px;
    }

    /* Redesigned Modern Footer */
    .footer-main {
        background: linear-gradient(180deg, #f0fcff 0%, #d0f3f8 100%);
        padding: 70px 0 0;
        position: relative;
        overflow: hidden;
    }

    .footer-title {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 25px;
        color: #1a6f82;
        position: relative;
        display: inline-block;
        letter-spacing: 1px;
        text-transform: uppercase;
    }

    .footer-title::after {
        content: '';
        position: absolute;
        bottom: -8px;
        left: 0;
        width: 40px;
        height: 3px;
        background: linear-gradient(90deg, #2ca0b9, transparent);
    }

    .footer-links {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-links li {
        margin-bottom: 12px;
        position: relative;
        padding-left: 0;
        transition: all 0.3s ease;
    }

    .footer-links li::before {
        content: '';
        position: absolute;
        left: 0;
        top: 50%;
        transform: translateY(-50%);
        width: 0;
        height: 2px;
        background: #2ca0b9;
        transition: all 0.3s ease;
        opacity: 0;
    }

    .footer-links li:hover {
        padding-left: 15px;
    }

    .footer-links li:hover::before {
        width: 10px;
        opacity: 1;
    }

    .footer-links a {
        color: #444;
        text-decoration: none;
        font-size: 15px;
        font-weight: 500;
        transition: all 0.3s ease;
        position: relative;
        /* display: inline-block; */
    }

    .footer-links a::after {
        content: '';
        position: absolute;
        bottom: -3px;
        left: 0;
        width: 0;
        height: 2px;
        background: linear-gradient(90deg, #2ca0b9, transparent);
        transition: width 0.3s ease;
    }

    .footer-links a:hover {
        color: #2ca0b9;
    }

    .footer-links a:hover::after {
        width: 100%;
    }

    /* Enhanced Newsletter */
    .newsletter {
        margin-top: 20px;
        position: relative;
        padding: 25px;
        border-radius: 15px;
        background: rgba(255, 255, 255, 0.7);
        backdrop-filter: blur(10px);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .newsletter:hover {
        box-shadow: 0 15px 40px rgba(44, 160, 185, 0.1);
        transform: translateY(-5px);
    }

    .newsletter-text {
        font-size: 15px;
        color: #444;
        margin-bottom: 20px;
        line-height: 1.6;
    }

    .form-control {
        height: 50px;
        border-radius: 25px 0 0 25px;
        border: 2px solid rgba(44, 160, 185, 0.2);
        padding-left: 20px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        box-shadow: none;
        border-color: #2ca0b9;
        background-color: rgba(44, 160, 185, 0.05);
    }

    .btn-subscribe {
        background: linear-gradient(135deg, #2ca0b9 0%, #1a6f82 100%);
        color: white;
        border: none;
        border-radius: 0 25px 25px 0;
        padding: 0 25px;
        font-weight: 600;
        height: 50px;
        transition: all 0.5s ease;
        position: relative;
        overflow: hidden;
        z-index: 1;
    }

    .btn-subscribe::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: all 0.5s ease;
        z-index: -1;
    }

    .btn-subscribe:hover::before {
        left: 100%;
    }

    .btn-subscribe:hover {
        background: linear-gradient(135deg, #1a6f82 0%, #2ca0b9 100%);
        box-shadow: 0 5px 15px rgba(44, 160, 185, 0.3);
        transform: translateY(-2px);
    }

    /* Enhanced Payment Partners */
    .payment-partners {
        padding: 40px 0;
        position: relative;
    }

    .payment-title {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 25px;
        color: #1a6f82;
        position: relative;
        display: inline-block;
        letter-spacing: 1px;
    }

    .payment-title::after {
        content: '';
        position: absolute;
        bottom: -8px;
        left: 0;
        width: 40px;
        height: 3px;
        background: linear-gradient(90deg, #2ca0b9, transparent);
    }

    .payment-icons {
        display: flex;
        flex-wrap: wrap;
        gap: 15px;
        align-items: center;
    }

    .payment-icons img {
        height: 35px;
        transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        filter: grayscale(100%) opacity(0.7);
    }

    .payment-icons img:hover {
        transform: translateY(-10px) scale(1.1);
        filter: grayscale(0%) opacity(1);
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }

    /* Social Icons with Hover Effects */
    .social-icon {
        display: inline-flex;
        align-items: center;
        margin-right: 10px;
        color: #555;
        font-size: 15px;
        transition: all 0.3s ease;
    }

    .social-icon i {
        width: 35px;
        height: 35px;
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 50%;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        margin-right: 10px;
        transition: all 0.3s ease;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .social-icon:hover {
        color: #2ca0b9;
        transform: translateX(5px);
    }

    .social-icon:hover i {
        background: linear-gradient(135deg, #2ca0b9 0%, #1a6f82 100%);
        color: white;
        box-shadow: 0 8px 20px rgba(44, 160, 185, 0.3);
    }

    /* Enhanced Wave Animation */
    .wave {
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 120px;
        background: url('data:image/svg+xml;utf8,<svg viewBox="0 0 1440 320" xmlns="http://www.w3.org/2000/svg"><path fill="%23ffffff" fill-opacity="1" d="M0,192L48,197.3C96,203,192,213,288,229.3C384,245,480,267,576,250.7C672,235,768,181,864,181.3C960,181,1056,235,1152,234.7C1248,235,1344,181,1392,154.7L1440,128L1440,320L1392,320C1344,320,1248,320,1152,320C1056,320,960,320,864,320C768,320,672,320,576,320C480,320,384,320,288,320C192,320,96,320,48,320L0,320Z"></path></svg>');
        background-size: cover;
        background-repeat: no-repeat;
        z-index: 1;
    }

    /* Enhanced Animations */
    @keyframes pulse {
        0% {
            transform: scale(1);
            opacity: 1;
        }

        50% {
            transform: scale(1.05);
            opacity: 0.8;
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    .animate-pulse {
        animation: pulse 3s infinite ease-in-out;
    }

    .animate-fade-in {
        opacity: 0;
        transform: translateY(30px);
        transition: opacity 0.8s ease, transform 0.8s ease;
    }

    .animate-fade-in.visible {
        opacity: 1;
        transform: translateY(0);
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive Design Enhancements */
    @media (max-width: 1199px) {
        .stat-icon {
            width: 80px;
            height: 80px;
        }

        .stat-icon img {
            width: 40px;
            height: 40px;
        }

        .stat-number {
            font-size: clamp(1.8rem, 2.5vw, 2.5rem);
        }
    }

    @media (max-width: 991px) {
        .footer-section {
            margin-bottom: 40px;
        }

        .newsletter {
            padding: 20px;
        }
    }

    @media (max-width: 768px) {
        .stats-section {
            padding: 40px 0;
        }

        .stat-icon {
            width: 70px;
            height: 70px;
            margin-bottom: 15px;
        }

        .stat-icon img {
            width: 35px;
            height: 35px;
        }

        .stat-number {
            font-size: clamp(1.5rem, 2vw, 2rem);
        }

        .footer-title {
            margin-bottom: 20px;
        }

        .wave {
            height: 60px;
        }

        .payment-icons img {
            height: 30px;
        }

        .footer-links li {
            margin-bottom: 10px;
        }
    }

    @media (max-width: 576px) {
        .stat-item {
            padding: 20px 15px;
        }

        .stat-text {
            font-size: 14px;
        }

        .company-description {
            font-size: 14px;
        }

        .footer-links a {
            font-size: 14px;
        }

        .newsletter-text {
            font-size: 14px;
        }

        .form-control {
            height: 45px;
        }

        .btn-subscribe {
            height: 45px;
            padding: 0 20px;
        }
    }

    /* Glassmorphism Effect */
    .glass-card {
        background: rgba(255, 255, 255, 0.7);
        backdrop-filter: blur(10px);
        border-radius: 15px;
        border: 1px solid rgba(255, 255, 255, 0.3);
        box-shadow: 0 8px 32px rgba(31, 38, 135, 0.1);
    }

    /* Contact Section Enhancements */
    .contact-item {
        display: flex;
        align-items: flex-start;
        margin-bottom: 15px;
    }

    .contact-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #2ca0b9 0%, #1a6f82 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin-right: 15px;
        flex-shrink: 0;
        box-shadow: 0 5px 15px rgba(44, 160, 185, 0.3);
    }

    .contact-info {
        flex: 1;
    }

    .contact-info p {
        margin: 0;
        color: #444;
    }

    .contact-info a {
        color: #2ca0b9;
        transition: all 0.3s ease;
    }

    .contact-info a:hover {
        color: #1a6f82;
        text-decoration: none;
    }
</style>

<main class="flex-grow-1">
    <!-- Main content would go here -->
</main>

{{-- @if (!Request::routeIs('home'))
    <!-- Enhanced Stats Section with Animated Icons -->
    <section class="stats-section">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-4 mb-md-0">
                    <div class="stat-item animate-fade-in" data-delay="100">
                        <div class="d-flex justify-content-center">
                            <div class="stat-icon">
                                <img src="https://img.icons8.com/color/48/000000/pharmacy-shop.png" alt="Pharmacy" class="img-fluid">
                            </div>
                        </div>
                        <div class="stat-number">1000+</div>
                        <div class="stat-text">Physical Stores Nationwide</div>
                    </div>
                </div>
                <div class="col-md-4 mb-4 mb-md-0">
                    <div class="stat-item animate-fade-in" data-delay="300">
                        <div class="d-flex justify-content-center">
                            <div class="stat-icon">
                                <img src="https://img.icons8.com/color/48/000000/marker.png" alt="Pincodes" class="img-fluid">
                            </div>
                        </div>
                        <div class="stat-number">20,000+</div>
                        <div class="stat-text">Delivery Locations Served</div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="stat-item animate-fade-in" data-delay="500">
                        <div class="d-flex justify-content-center">
                            <div class="stat-icon">
                                <img src="https://img.icons8.com/color/48/000000/conference-call.png" alt="Customers" class="img-fluid">
                            </div>
                        </div>
                        <div class="stat-number">9M+</div>
                        <div class="stat-text">Satisfied Customers</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Enhanced Company Info -->
    <section class="company-info">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center animate-fade-in">
                    <a href="{{ route('home') }}" class="d-block">
                        @if (get_setting('footer_logo') != null)
                            <img class="company-logo" src="{{ uploaded_asset(get_setting('footer_logo')) }}" data-src="{{ uploaded_asset(get_setting('footer_logo')) }}" alt="{{ env('APP_NAME') }}">
                        @else
                            <img class="company-logo" src="{{ static_asset('assets/img/placeholder-rect.jpg') }}" data-src="{{ static_asset('assets/img/logo.png') }}" alt="{{ env('APP_NAME') }}">
                        @endif
                    </a>
                    <p class="company-description">
                        {!! get_setting('about_us_description', null, App::getLocale()) !!}
                    </p>
                </div>
            </div>
        </div>
    </section>
@endif --}}

<!-- Redesigned Modern Footer -->
<footer class="footer-main">
    <!-- Enhanced Wave Animation -->
    <div class="wave"></div>

    <div class="container position-relative" style="z-index: 2;">
        <div class="row">
            <!-- Company Section -->
            <div class="col-lg-3 col-md-6 col-sm-6 footer-section mb-4 mb-lg-0">
                <h3 class="footer-title animate-fade-in">COMPANY</h3>
                <ul class="footer-links">
                    <li><a href="{{ url('about-us') }}">About Us</a></li>
                    <li><a href="#">Customer Testimonials</a></li>
                    <li><a href="#">Press & Media</a></li>
                    <li><a href="#">Career Opportunities</a></li>
                    <li><a href="{{ url('contact-us') }}">Contact Us</a></li>
                </ul>
            </div>

            <!-- Policies Section -->
            <div class="col-lg-3 col-md-6 col-sm-6 footer-section mb-4 mb-lg-0">
                <h3 class="footer-title animate-fade-in">OUR POLICIES</h3>
                <ul class="footer-links">
                    <li><a href="{{ url('terms') }}">Terms and Conditions</a></li>
                    <li><a href="{{ url('/privacy-policy') }}">Privacy Policy</a></li>
                    <li><a href="{{ url('return-policy') }}">Returns and Refunds</a></li>
                    <li><a href="{{ url('support-policy') }}">Support Policy</a></li>
                </ul>
            </div>

            <!-- My Account Section -->
            <div class="col-lg-3 col-md-6 col-sm-6 footer-section mb-4 mb-lg-0">
                <h3 class="footer-title animate-fade-in">MY ACCOUNT</h3>
                <ul class="footer-links">
                    @if (Auth::check())
                        <li>
                            <a href="{{ route('logout') }}">
                                {{ translate('Logout') }}
                            </a>
                        </li>
                    @else
                        <li>
                            <a href="javascript:void(0)" onclick="showLoginModal()">
                                {{ translate('Login') }}
                            </a>
                        </li>
                    @endif
                    <li>
                        <a href="{{ route('purchase_history.index') }}">
                            {{ translate('Order History') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('wishlists.index') }}">
                            {{ translate('My Wishlist') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('orders.track') }}">
                            {{ translate('Track Order') }}
                        </a>
                    </li>
                    @if (addon_is_activated('affiliate_system'))
                        <li>
                            <a href="{{ route('affiliate.apply') }}">
                                {{ translate('Become an affiliate partner') }}
                            </a>
                        </li>
                    @endif
                </ul>
            </div>

            <!-- Social & Contact Section -->
            <div class="col-lg-3 col-md-6 col-sm-6 footer-section mb-4 mb-lg-0">
                <h3 class="footer-title animate-fade-in">CONNECT WITH US</h3>
                <ul class="footer-links">
                    <li>
                        <a href="{{ get_setting('facebook_link') ?: '#' }}" target="_blank" class="social-icon">
                            <i class="fab fa-facebook-f"></i>
                            <span>Facebook</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ get_setting('twitter_link') ?: '#' }}" target="_blank" class="social-icon">
                            <i class="fab fa-twitter"></i>
                            <span>Twitter</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ get_setting('instagram_link') ?: '#' }}" target="_blank" class="social-icon">
                            <i class="fab fa-instagram"></i>
                            <span>Instagram</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ get_setting('youtube_link') ?: '#' }}" target="_blank" class="social-icon">
                            <i class="fab fa-youtube"></i>
                            <span>YouTube</span>
                        </a>
                    </li>
                    <li>
                        <a href="{{ get_setting('linkedin_link') ?: '#' }}" target="_blank" class="social-icon">
                            <i class="fab fa-linkedin-in"></i>
                            <span>LinkedIn</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>

        <!-- Newsletter & Contact Row -->
        <div class="row mt-5">
            <!-- Newsletter Column -->
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="newsletter glass-card animate-fade-in">
                    <h3 class="footer-title mb-3">SUBSCRIBE TO OUR NEWSLETTER</h3>
                    <p class="newsletter-text">
                        Get exclusive access to health tips, special offers, and latest product updates delivered directly to your inbox.
                    </p>
                    <form method="POST" action="{{ route('subscribers.store') }}">
                        @csrf
                        <div class="input-group">
                            <input type="email" name="email" class="form-control" placeholder="Enter your email address" aria-label="Email" required>
                            <button class="btn btn-subscribe" type="submit">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Contact Info Column -->
            <div class="col-lg-6">
                <div class="glass-card p-4 animate-fade-in">
                    <h3 class="footer-title mb-4">CONTACT INFORMATION</h3>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="contact-info">
                            <p class="fw-bold mb-1">Address</p>
                            <p>{{ get_setting('contact_address', null, App::getLocale()) }}</p>
                        </div>
                    </div>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-phone-alt"></i>
                        </div>
                        <div class="contact-info">
                            <p class="fw-bold mb-1">Phone</p>
                            <p>{{ get_setting('contact_phone') }}</p>
                        </div>
                    </div>

                    <div class="contact-item">
                        <div class="contact-icon">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <div class="contact-info">
                            <p class="fw-bold mb-1">Email</p>
                            <p>
                                <a href="mailto:{{ get_setting('contact_email') }}">{{ get_setting('contact_email') }}</a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Seller Zone Section -->
        <div class="row mt-5">
            <div class="col-md-6 mb-4 mb-md-0">
                <div class="glass-card p-4 animate-fade-in">
                    <h3 class="footer-title">{{ translate('Seller Zone') }}</h3>
                    <ul class="footer-links">
                        <li>{{ translate('Become A Seller') }}
                            <a href="{{ route('shops.create') }}" class="fw-bold text-primary ms-2">{{ translate('Login Now') }}</a>
                        </li>
                        <li><a href="{{ route('seller.login') }}">{{ translate('Seller Login') }}</a></li>
                    </ul>
                </div>
            </div>

            <!-- Payment Partners -->
            <div class="col-md-6">
                <div class="glass-card p-4 animate-fade-in">
                    <h3 class="payment-title">OUR PAYMENT PARTNERS</h3>
                    <div class="payment-icons">
                        <img src="https://akshathealthcare.in/public/assets/img/google-pay.png" alt="Google Pay">
                        <img src="https://akshathealthcare.in/public/assets/img/phone-pe.png" alt="PhonePe">
                        <img src="https://akshathealthcare.in/public/assets/img/paytm.png" alt="Paytm">
                        <img src="https://akshathealthcare.in/public/assets/img/card.png" alt="Card">
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-12">
                <ul class="list-unstyled d-flex flex-wrap gap-3 justify-content-around font-weight-bold">
                    <li class="mb-2"><a href="{{ url('terms') }}">Terms and Conditions</a></li>
                    <li class="mb-2"><a href="{{ url('/privacy-policy') }}">Privacy Policy</a></li>
                    <li class="mb-2"><a href="{{ url('return-policy') }}">Returns and Refunds</a></li>
                    <li class="mb-2"><a href="{{ url('support-policy') }}">Support Policy</a></li>
                </ul>
            </div>
        </div>

        <!-- Copyright Section -->
        <div class="row mt-2">
            <div class="col-md-12 text-center font-weight-bold pb-4">
                <p class="mb-0">© {{ date('Y') }} {{ get_setting('site_name') }}. All Rights Reserved.</p>
            </div>
        </div>
    </div>
</footer>

<!-- Bootstrap JS Bundle with Popper -->
{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> --}}

<script>
    // Advanced animation for elements
    document.addEventListener('DOMContentLoaded', function() {
        const animateElements = document.querySelectorAll('.animate-fade-in');

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    // Get the delay attribute or default to 0
                    const delay = entry.target.getAttribute('data-delay') || 0;

                    // Add a timeout to stagger the animations
                    setTimeout(() => {
                        entry.target.classList.add('visible');
                    }, delay);

                    // Unobserve after animation to improve performance
                    observer.unobserve(entry.target);
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        });

        animateElements.forEach(element => {
            observer.observe(element);
        });

        // Counter animation for stat numbers
        const statNumbers = document.querySelectorAll('.stat-number');

        statNumbers.forEach(number => {
            const finalValue = number.innerText;

            // Check if it has a plus sign
            const hasPlus = finalValue.includes('+');

            // Get the numeric value
            let numericValue = hasPlus ?
                finalValue.replace('+', '').replace(/,/g, '') :
                finalValue.replace(/,/g, '');

            numericValue = parseInt(numericValue);

            // Animation duration in milliseconds
            const animationDuration = 2000;
            const frameDuration = 16; // ~60fps
            const totalFrames = Math.round(animationDuration / frameDuration);

            // Easing function for smoother counting
            const easeOutQuad = t => t * (2 - t);

            let frame = 0;

            // Start at a small value instead of 0
            const startValue = Math.floor(numericValue / 100);

            number.textContent = startValue + (hasPlus ? '+' : '');

            const counter = setInterval(() => {
                frame++;

                // Calculate current progress
                const progress = easeOutQuad(frame / totalFrames);

                // Calculate the value for this frame
                const currentValue = Math.round(startValue + (numericValue - startValue) * progress);

                // Format with commas for thousands
                const formattedValue = currentValue.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");

                // Update the text
                number.textContent = formattedValue + (hasPlus ? '+' : '');

                // Stop the animation when done
                if (frame === totalFrames) {
                    clearInterval(counter);
                    number.textContent = finalValue;
                }
            }, frameDuration);
        });
    });
</script>
