
<div class="section order-summary">
    <h2>Order Summary</h2>
    
    @php
        $subtotal_for_min_order_amount = 0;
        $subtotal = 0;
        $tax = 0;
        $product_shipping_cost = 0;
        $shipping = 0;
        $coupon_code = null;
        $coupon_discount = 0;
        $total_point = 0;
    @endphp
    <!-- Product Details with Discount Badge -->
    @foreach($carts as $cart)
    @php
        $product = $cart->product ?: get_single_product($cart['product_id']);
        $product_price = cart_product_price($cart, $product, false, false) * $cart['quantity'];
        $subtotal_for_min_order_amount += $product_price;
        $subtotal += $product_price;
        
        $i_tax = cart_product_tax($cart, $product, false) * $cart['quantity'];
        $tax += $i_tax;
        
        $shipping += $cart['shipping_cost'];
        
        $discount = 0;
        if ((get_setting('coupon_system') == 1) && ($cart->coupon_applied == 1)) {
            $discount = $cart->discount;
            $coupon_code = $cart->coupon_code;
            $coupon_discount += $discount;
        }
        $product_amount = round($product_price + $discount);
        
    @endphp
    <div class="product-item" data-original_price="{{ $product_price }}" data-discounted_price="{{ $product_amount }}">
        <div>
            @if($discount > 0)
            @if($product->discount_type === 'amount')
            <span class="discount-badge">{{ single_price($discount) }} OFF</span>
            @else
            <span class="discount-badge">{{ intval($discount) }}% OFF</span>
            @endif
            @endif
            <span>{{ $product->name }}</span>
        </div>
        <div class="quantity-controls">
            <button onclick="updateQuantity(this, {{ $cart->id }}, -1)">-</button>
            <span class="quantity-product">{{ $cart->quantity }}</span>
            <button onclick="updateQuantity(this, {{ $cart->id }}, 1)">+</button>
            <span class="price-product">{{ single_price($product_amount) }}</span>
            <small>(Original: {{ single_price($product_price) }})</small>
        </div>
    </div>
    @endforeach

    @if (get_setting('coupon_system') == 1)
        <!-- Coupon Section with Badge -->
        <div class="coupon-section">
            <input type="text" id="coupon-code" placeholder="Enter coupon code" value="{{ $coupon_code }}" />
            <button type="submit">Apply Coupon</button>
            <span class="coupon-badge">%</span>
        </div>
    @endif
    <!-- Price Details -->
    <div class="price-details">
        <div class="price-row">
            <span>Sub Total</span>
            <span id="subtotal">{{ single_price($subtotal) }}</span>
        </div>
        <div class="price-row">
            <span>Total Discount</span>
            <span id="discount">-{{ single_price($coupon_discount) }}</span>
        </div>
        <div class="price-row">
            <span>Shipping Fee</span>
            <span id="shipping">{{ single_price($shipping) }}</span>
        </div>
        @if($tax > 0)
        <div class="price-row">
            <span>Tax</span>
            <span id="tax">{{ single_price($tax) }}</span>
        </div>
        @endif
        @if(Auth::check())
        <div class="price-row wallet">
            <span>Wallet Balance ({{ single_price(Auth::user()->balance) }})</span>
            <span id="wallet">₹0</span>
            <input type="number" id="wallet_used_amount" class="wallet-input" min="0" max="1000" placeholder="Add" value="{{ isset($wallet_used_amount) ? $wallet_used_amount : '' }}" onchange="updateWallet()" @readonly(Auth::user()->balance <= 0) />
        </div>
        @endif
        @php
            $total = $subtotal + $tax + $shipping;
            $club_point = 0;
            if (Session::has('club_point')) {
                $club_point = Session::get('club_point');
                $total -= $club_point;
            }
            if ($coupon_discount > 0) {
                $total -= $coupon_discount;
            }
        @endphp
        <div class="price-row">
            <span>Total</span>
            <span id="total">{{ single_price($total) }}</span>
        </div>
    </div>

    <!-- Payment Methods -->
    <div class="payment-methods">
        <div class="form-group">
            <label for="payment">Payment Method</label>
            <select id="payment_method" name="payment_method" onchange="updatePaymentType(this)">
                <option value="">Select Payment Method</option>
                @foreach(get_payment_methods as $payment_method)
                <option value="{{ $payment_method }}">{{ ucwords(translate($payment_method)) }}</option>
                @endforeach
                <!--<option value="phone_pay" @selected(old('payment_method', (isset($payment_method) ? $payment_method : "")) === 'phone_pay')>Phone Pay</option>-->
                <!--<option value="card" @selected(old('payment_method', (isset($payment_method) ? $payment_method : "")) === 'card')>Card</option>-->
            </select>
        </div>
    </div>

    <!-- Agree Box -->
    <div class="pt-2 fs-14 d-flex mt-2">
        <label class="aiz-checkbox">
            <input type="checkbox" required id="agree_checkbox" onchange="agreeCheckbox()">
            <span class="aiz-square-check"></span>
            <span>{{ translate('I agree to the') }}</span>
        </label>
        <a href="{{ route('terms') }}"
            class="fw-700 ml-1">{{ trim(translate('terms and conditions')) }}</a>,
        <a href="{{ route('returnpolicy') }}"
            class="fw-700 mx-1">{{ trim(translate('return policy')) }}</a> &
        <a href="{{ route('privacypolicy') }}"
            class="fw-700 ml-1">{{ trim(translate('privacy policy')) }}</a>
    </div>
    <div class="mt-4">
        <!-- Pay Now Button -->
        <button type="button" id="submitOrderBtn" class="pay-now" onclick="submitOrder(this)" disabled>
            {{ translate('Pay Now')}}
        </button>
    </div>
</div>