<div class="section order-summary">
    <h2>Order Summary</h2>

    @php
        $subtotal_for_min_order_amount = 0;
        $subtotal = 0;
        $tax = 0;
        $product_shipping_cost = 0;
        $shipping = 0;
        $coupon_code = null;
        $coupon_discount = 0;
        $total_point = 0;
        $is_cash_on_delivery = true;
    @endphp
    <!-- Product Details with Discount Badge -->
    @foreach ($carts as $cart)
        @php
            $product = $cart->product;
            $quantity = floatval($cart->quantity);
            // $product_variation_price = product_variation_discount($product, $cart->variation);

            // $discount = (isset($product_variation_price['total']) ? $product_variation_price['total'] : 0) * $quantity;
            $discount = $cart->discount;
            $coupon_discount += $discount;

            // $product_price = (isset($product_variation_price['price']) ? $product_variation_price['price'] : 0) * $quantity;
            $product_price = cart_product_price($cart, $product, false, false) * $cart->quantity;
            $subtotal += $product_price;
            $subtotal_for_min_order_amount += $product_price;

            $i_tax = product_tax($product, $cart->variation) * $quantity;
            $tax += $i_tax;

            $shipping += $cart->shipping_cost;

            if (empty($coupon_code) && $cart->coupon_code && $cart->coupon_applied) {
                $coupon_code = $cart->coupon_code;
            }

            $product_amount = round($product_price);
            if ($product_price > $discount) {
                $product_amount = round($product_price - $discount);
            }
            $is_cash_on_delivery = $product->cash_on_delivery;

            $show_discount_label = true;
            if (isset($cart->coupon)) {
                if ($cart->coupon->type == 'cart_base') {
                    $show_discount_label = false;
                }
            }

        @endphp
        <div class="product-item">
            <div>
                @if ($discount > 0 && $show_discount_label)
                    <span class="discount-badge">{{ single_price($discount) }} OFF</span>
                @endif
                <span>{{ $product->name }}</span>
            </div>
            <div class="quantity-controls">
                <button onclick="updateQuantity(this, {{ $cart->id }}, -1)">-</button>
                <span class="quantity-product">{{ $quantity }}</span>
                <button onclick="updateQuantity(this, {{ $cart->id }}, 1)">+</button>
                <span class="price-product">{{ single_price($product_amount) }}</span>
                <small>(Original: {{ single_price($product_price) }})</small>
            </div>
            <span
                title="Remove {{ $product->name }} From Cart"
                data-owner_id="{{ $cart->owner_id }}"
                data-productid="{{ $product->id }}"
                class="cross-mark deleteproduct"
                style="cursor: pointer;">
                <i class="fa-solid fa-xmark"></i>
            </span>

        </div>
    @endforeach

    @if (get_setting('coupon_system') == 1)
        <!-- Coupon Section with Badge -->
        <div class="coupon-section">
            <input type="text" id="coupon-code" @readonly($coupon_discount > 0 && $coupon_code) placeholder="Enter coupon code" value="{{ $coupon_code }}" />
            @if ($coupon_discount > 0 && $coupon_code)
                <button type="button" id="coupon-remove">Remove Coupon</button>
            @else
                <button type="button" id="coupon-apply">Apply Coupon</button>
            @endif
            <span class="coupon-badge">%</span>
        </div>
    @endif
    <!-- Price Details -->
    <div class="price-details">
        <div class="price-row">
            {{-- <span>Sub Total {{ $discount }}</span> --}}
            <span>Sub Total</span>
            <span id="subtotal">{{ single_price($subtotal) }}</span>
        </div>
        <div class="price-row">
            <span>Total Discount</span>
            <span id="discount">-{{ single_price($coupon_discount) }}</span>
        </div>
        <div class="price-row">
            <span>Shipping Fee</span>
            <span id="shipping">{{ single_price($shipping) }}</span>
        </div>
        @if ($tax > 0)
            <div class="price-row">
                <span>Tax</span>
                <span id="tax">{{ single_price($tax) }}</span>
            </div>
        @endif
        @if (Auth::check() && Auth::user()->balance > 0)
            <div class="price-row wallet">
                <span>Wallet Balance ({{ single_price(Auth::user()->balance) }})</span>
                <span id="wallet">₹0</span>
                <input type="number" id="wallet_used_amount" class="wallet-input" min="0" max="1000" placeholder="Add" value="{{ isset($wallet_used_amount) ? $wallet_used_amount : '' }}" onchange="updateWallet()" @readonly(Auth::user()->balance <= 0) />
            </div>
        @endif
        @php
            $total = $subtotal + $tax + $shipping;
            $club_point = 0;
            if (Session::has('club_point')) {
                $club_point = Session::get('club_point');
                $total -= $club_point;
            }
            if ($coupon_discount > 0) {
                $total -= $coupon_discount;
            }
        @endphp
        <div class="price-row">
            <span>Total (<span style="font-size: 13px;">Inclusive of all Taxes</span>)</span>
            <span id="total">{{ single_price($total) }}</span>
        </div>
    </div>

    <!-- Payment Methods -->
    <div class="payment-methods">
        <div class="form-group">
            <label for="payment">Payment Method</label>
            <select id="payment_method" name="payment_method" onchange="updatePaymentType(this)" class="aiz-selectpicker w-100">
                <option value="">Select Payment Method</option>
                @foreach (get_payment_methods() as $method)
                    <option value="{{ $method }}" @selected(old('payment_method', isset($payment_method) ? $payment_method : '') === $method)>{{ ucwords(translate($method)) }}</option>
                @endforeach
                @if ($is_cash_on_delivery)
                    <option value="cash_on_delivery">{{ translate('Cash On Delivery') }}</option>
                @endif
                @if ((get_setting('wallet_system') == 1) && (Auth::check() && Auth::user()->balance > 0))
                    <option value="wallet">{{ translate('Wallet') }}</option>
                @endif
            </select>
        </div>
    </div>

    <!-- Agree Box -->
    <div class="pt-2 fs-14 d-flex mt-2">
        <label class="aiz-checkbox">
            <input type="checkbox" required id="agree_checkbox" onchange="agreeCheckbox(this)">
            <span class="aiz-square-check"></span>
            <span>{{ translate('I agree to the') }}</span>
        </label>
        <a href="{{ route('terms') }}"
            class="fw-700 ml-1">{{ trim(translate('terms and conditions')) }}</a>,
        <a href="{{ route('returnpolicy') }}"
            class="fw-700 mx-1">{{ trim(translate('return policy')) }}</a> &
        <a href="{{ route('privacypolicy') }}"
            class="fw-700 ml-1">{{ trim(translate('privacy policy')) }}</a>
    </div>
    <div class="mt-4">
        <!-- Pay Now Button -->
        <button type="button" id="submitOrderBtn" class="pay-now" onclick="submitOrder(this)" disabled>
            {{ translate('Pay Now') }}
        </button>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        $(document).on('click', '.deleteproduct', function() {
            let owner_id = $(this).data('owner_id');
            let productid = $(this).data('productid');

            fetch(`deleteproductcheckout/${owner_id}/${productid}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Request failed');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        AIZ.plugins.notify('success', data.message);
                        setTimeout(() => {
                            window.location.reload();
                        }, 1000)
                    } else {
                        AIZ.plugins.notify('error', data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Something went wrong while deleting the product.');
                });
        });
    });
</script>
