@section('page-styles')
<style>
    .order-summary-list {
        padding: 10px 0px;
        border-bottom: 1px solid #e4e4e4;
        margin: 0px 1px;
    }
    .order-summary-list .checkout-plus-minus button {
        height: 18px !important;!i;!;
        width: 18px !important;!i;!;
        line-height: 1px !important;!i;!;
        font-size: 12px;
        padding: 0px !important;!i;!;
    }
    
    .order-summary-list .checkout-plus-minus input {
        width: 30px !important;
        height: 18px;
    }
    
    .order-summary-list .discount-badge {
        position: absolute;
        left: 25px;
        top: -13px;
        width: 60px;
        height: 18px;
        padding: 0 6px;
        border-radius: 3px;
        color: #fff;
        font-size: 11px;
        background: red;
    }

    .order-summary .coupon-section {
        background-color: #f5f5f5;
        padding: 10px;
        margin: 16px 0px;
        border-radius: 5px;
    }

    .bg-light-success {
        background-color: #cff7b6 !important;
        color: #296603;
        font-weight: bold;
    }
</style>
@endsection
<div class="z-3 sticky-top-lg">
    
    <div class="card pt-2">
        <div class="card-header" style="border-bottom: none;padding-top: 10px;padding-bottom: 0px;">
            <h4>{{ translate('Order Summary') }}</h4>
        </div>
        <div class="card-body">
            <div class="order-summary">
                @php
                    $subtotal_for_min_order_amount = 0;
                    $subtotal = 0;
                    $tax = 0;
                    $product_shipping_cost = 0;
                    $shipping = 0;
                    $coupon_code = null;
                    $coupon_discount = 0;
                    $total_point = 0;
                @endphp
                @foreach ($carts as $key => $cartItem)
                    @php
                        $product = $cartItem->product ?: get_single_product($cartItem['product_id']);
                        $product_price = cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                        $subtotal_for_min_order_amount += $product_price;
                        $subtotal += $product_price;
                        
                        $i_tax = cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                        $tax += $i_tax;
                        
                        $shipping += $cartItem['shipping_cost'];
                        
                        $discount = 0;
                        if ((get_setting('coupon_system') == 1) && ($cartItem->coupon_applied == 1)) {
                            $discount = $cartItem->discount;
                            $coupon_code = $cartItem->coupon_code;
                            $coupon_discount += $discount;
                        }
                        $product_amount = round($product_price + $discount);
                        $product_stock = $product->stocks->where('variant', $cartItem->variation)->first();
                        $current_stock = $product_stock ? $product_stock->qty : 0;
                    @endphp
                    <div class="row order-summary-list">
                        <div class="col-5 p-0">
                            <span title="{{ $product->name }}">{{ strlen($product->name) > 20 ? substr(ucwords($product->name), 0, 20)."..." : ucwords($product->name) }}</span>
                            @if($discount > 0)
                                @if($product->discount_type === 'amount')
                                    <span class="discount-badge">₹{{ round($discount) }} OFF</span>
                                @else
                                    <span class="discount-badge">₹{{ round($discount) }} OFF</span>
                                @endif
                            @endif
                        </div>
                        <div class="col-7 d-flex justify-content-end p-0">
                            @if ($proceed == 1)
                            <span class="d-flex aiz-plus-minus mr-0 ml-0 checkout-plus-minus flex-row-reverse">
                                <button
                                    class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                    type="button" data-type="plus"
                                    data-field="quantity[{{ $cartItem->id }}]">
                                    <i class="las la-plus"></i>
                                </button>
                                <input type="number" name="quantity[{{ $cartItem->id }}]"
                                    class="col border-0 text-center px-0 fs-14 input-number"
                                    placeholder="1" value="{{ $cartItem->quantity }}"
                                    min="{{ $product->min_qty }}"
                                    max="{{ $current_stock }}"
                                    onchange="updateQuantity({{ $cartItem->id }}, this)">
                                <button
                                    class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                    type="button" data-type="minus"
                                    data-field="quantity[{{ $cartItem->id }}]">
                                    <i class="las la-minus"></i>
                                </button>
                            </span>
                            @endif
                            <span class="mx-2">₹{{ round($product_amount) }}</span>
                            <span>(Original: ₹{{ round($product_price) }})</span>
                        </div>
                    </div>
                @endforeach
                <!-- Coupon System -->
                @if (get_setting('coupon_system') == 1)
                    @if ($coupon_discount > 0 && $coupon_code)
                        <div class="coupon-section">
                            <form class="" id="remove-coupon-form" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="proceed" value="{{ $proceed }}">
                                <div class="input-group">
                                    <div class="form-control">{{ $coupon_code }}</div>
                                    <div class="input-group-append">
                                        <button type="button" id="coupon-remove"
                                            class="btn btn-primary">{{ translate('Change Coupon') }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    @else
                        <div class="coupon-section">
                            <form class="" id="apply-coupon-form" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="proceed" value="{{ $proceed }}">
                                <div class="input-group">
                                    <input type="text" class="form-control rounded-0" name="code"
                                        onkeydown="return event.key != 'Enter';"
                                        placeholder="{{ translate('Have coupon code? Apply here') }}" required>
                                    <div class="input-group-append">
                                        <button type="button" id="coupon-apply"
                                            class="btn btn-primary rounded-0">{{ translate('Apply') }}</button>
                                    </div>
                                </div>
                                @if (!auth()->check())
                                    <small>{{ translate('You must Login as customer to apply coupon') }}</small>
                                @endif
    
                            </form>
                        </div>
                    @endif
                @endif
                <div class="coupon-section">
                    <div class="d-flex justify-content-between py-1">
                        <span>Sub Total</span><span>{{ single_price(round($subtotal)) }}</span>
                    </div>
                    @php
                        $total_dis = $carts->sum('discount');
                    @endphp
                    @if($total_dis > 0)
                    <div class="d-flex justify-content-between py-1">
                        <span>Total Discount</span><span>-{{ single_price(round($total_dis)) }}</span>
                    </div>
                    @endif
                    @if ($shipping > 0)
                    <div class="d-flex justify-content-between py-1">
                        <span>Shipping Fee</span><span>{{ single_price(round($shipping)) }}</span>
                    </div>
                    @endif
                    <div class="d-flex justify-content-between py-1">
                        <span>Tax</span><span>{{ single_price(round($tax)) }}</span>
                    </div>
                    
                    @php
                        $total = $subtotal + $tax + $shipping - $total_dis;
                        $club_point = 0;
                        if (Session::has('club_point')) {
                            $club_point = Session::get('club_point');
                            $total -= $club_point;
                        }
                        if ($coupon_discount > 0) {
                            $total -= $coupon_discount;
                        }
                    @endphp
                    @if (Auth::user()->balance)
                    <div class="d-flex justify-content-between bg-light-success p-2 my-2 align-items-center">
                        <span>Wallet Balance ({{ single_price(Auth::user()->balance) }})</span>
                        <span>-{{ single_price(round($club_point)) }}</span>
                        <input class="form-control w-25 form-control-sm" readonly value="{{ round($club_point) }}" />
                    </div>
                    @endif
                    <div class="d-flex justify-content-between font-weight-bold py-1">
                        <span style="font-size: 16px;">Total</span><span style="font-size: 16px;">{{ single_price(round($total)) }}</span>
                    </div>
                </div>
            </div>
            
            @if ($proceed == 1)
                <!-- Continue to Shipping -->
                <div class="mt-4">
                    <a href="{{ route('checkout') }}" class="btn btn-primary btn-block fs-14 fw-700 rounded-0 px-4">
                        {{ translate('Proceed to Checkout')}} ({{ sprintf("%02d", count($carts)) }})
                    </a>
                </div>
            @else
                <!-- Agree Box -->
                <div class="pt-2 fs-14" style="line-height: 1;">
                    <label class="aiz-checkbox">
                        <input type="checkbox" required id="agree_checkbox" onchange="stepCompletionPaymentInfo()">
                        <span class="aiz-square-check"></span>
                        <span>{{ translate('I agree to the') }}</span>
                    </label>
                    <a href="{{ route('terms') }}"
                        class="fw-700">{{ translate('terms and conditions') }}</a>,
                    <a href="{{ route('returnpolicy') }}"
                        class="fw-700">{{ translate('return policy') }}</a> &
                    <a href="{{ route('privacypolicy') }}"
                        class="fw-700">{{ translate('privacy policy') }}</a>
                </div>
                <div class="mt-4">
                    <button type="button" id="submitOrderBtn" class="btn btn-primary btn-block fs-14 fw-700 rounded-0 px-4" onclick="submitOrder(this)" disabled>
                        {{ translate('Pay Now')}}
                    </button>
                </div>
            @endif
        </div>
    </div>
</div>
