@if ($substituteProducts->isNotEmpty())
    <style>
        .substitute-product-link {
            color: #0fb800 !important;
        }

        .substitute-product-link:hover {
            color: #002fc8 !important;
        }
    </style>

    <div class="bg-white border my-4">
        <div class="p-3 p-sm-4">
            <h3 class="fs-16 fw-700 mb-0">
                <span class="mr-4">{{ translate('Substitute Products') }}</span>
            </h3>
        </div>
        <div class="px-4">
            @foreach ($substituteProducts as $key => $related_product)
                <div class="d-flex justify-content-between align-items-center py-2 border-bottom">
                    <div>
                        <h4 class="mb-0 fs-14 fw-400">
                            <a href="{{ route('product', $related_product->slug) }}"
                                class="d-block text-decoration-none substitute-product-link">{{ $related_product->getTranslation('name') }}</a>
                        </h4>
                        <small class="text-muted">
                            {{ $related_product->manufacturer }}
                        </small>
                    </div>
                    <div class="text-right">
                        <div class="fs-14 fw-700">
                            ₹{{ number_format($related_product->unit_price, 2) }}/{{ $related_product->unit ?: 'Unit' }}
                        </div>
                        <small class="{{ $related_product->price_comparison['is_cheaper'] ? 'text-success' : 'text-danger' }}">
                            {{ $related_product->price_comparison['is_cheaper'] ? $related_product->price_comparison['percentage'] . '% cheaper' : $related_product->price_comparison['percentage'] . '% costlier' }}
                        </small>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endif
