@extends('frontend.layouts.app')

@section('content')
    <section class="pt-4 my-4">

        <div class="container">
            @php
                $todays_deal_products = filter_products(App\Models\Product::where('todays_deal', '1'))->orderBy('id', 'desc')->get();
            @endphp
            @if (count($todays_deal_products) > 0)
                <div class="col-12 col-lg-auto mt-4">
                    <div class="todays_deal bg-white rounded-2 overflow-hidden">
                        <div class="bg-soft-primary p-3 d-flex align-items-center justify-content-center">
                            <span class="fw-700 fs-18 mr-2 text-truncate">
                                {{ translate('Special Discount') }}
                            </span>
                        </div>
                        <div class="p-2">
                            <div class="row">
                                @foreach ($todays_deal_products as $key => $product)
                                    @if ($product != null)
                                        <div class="col-md-3">
                                            <a href="{{ route('product', $product->slug) }}" class="d-block p-2 text-reset bg-white h-100 rounded">
                                                <div class="row gutters-5 align-items-center" style="margin-bottom: 1.5px;">
                                                    <div class="col-md">
                                                        <div class="img">
                                                            <img
                                                                class="lazyload img-fit h-140px h-lg-90px"
                                                                src="{{ static_asset('assets/img/placeholder.jpg') }}"
                                                                data-src="{{ uploaded_asset($product->thumbnail_img) }}"
                                                                alt="{{ $product->getTranslation('name') }}"
                                                                onerror="this.onerror=null;this.src='{{ static_asset('assets/img/placeholder.jpg') }}';">
                                                        </div>
                                                    </div>
                                                    <div class="col-md mt-2 mt-md-0 text-center">
                                                        <div class="fs-14">
                                                            <span class="d-block text-primary fw-700">{{ $product->getTranslation('name') }}</span>
                                                            <span class="d-block text-primary fw-500">{{ home_discounted_base_price($product) }}</span>
                                                            @if (home_base_price($product) != home_discounted_base_price($product))
                                                                <del class="d-block opacity-70">{{ home_base_price($product) }}</del>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
@endsection
