@extends('frontend.layouts.user_panel')

@section('panel_content')
    <div class="aiz-titlebar mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="fs-20 fw-700 text-dark">{{ translate('Manage Profile') }}</h1>
            </div>
        </div>
    </div>

    <!-- Basic Info-->
    <div class="card rounded-0 shadow-none border">
        <div class="card-header pt-4 border-bottom-0">
            <h5 class="mb-0 fs-18 fw-700 text-dark">{{ translate('Basic Info') }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('auth.user.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <!-- Name-->
                <div class="form-group row">
                    <label class="col-md-2 col-form-label fs-14 fs-14">{{ translate('Your Name') }}</label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" placeholder="{{ translate('Your Name') }}"
                            name="name" value="{{ Auth::user()->name }}">
                    </div>
                </div>
                <!-- Phone-->
                <div class="form-group row">
                    <label class="col-md-2 col-form-label fs-14">{{ translate('Your Phone') }}</label>
                    <div class="col-md-10">
                        <input type="text" class="form-control rounded-0" placeholder="{{ translate('Your Phone') }}"
                            id="phone-code" name="phone" value="{{ format_mobile(Auth::user()->phone, 91, true) }}">
                    </div>
                </div>
                @if (Auth::user()->is_wholeseller == 1)
                    <!-- Drug License Number -->
                    <div class="form-group row">
                        <label class="col-md-2 col-form-label fs-14">{{ translate('Drug License No') }}</label>
                        <div class="col-md-10">
                            <input type="text" class="form-control rounded-0"
                                placeholder="{{ translate('Drug License Number') }}" name="drug_license_no"
                                value="{{ Auth::user()->drug_license_no }}">
                        </div>
                    </div>
                    <!-- GST Number -->
                    <div class="form-group row">
                        <label class="col-md-2 col-form-label fs-14">{{ translate('GST No') }}</label>
                        <div class="col-md-10">
                            <input type="text" class="form-control rounded-0"
                                placeholder="{{ translate('GST Number') }}" name="gst_no"
                                value="{{ Auth::user()->gst_no }}">
                        </div>
                    </div>
                @endif
                <!-- Photo-->
                <div class="form-group row">
                    <label class="col-md-2 col-form-label fs-14">{{ translate('Photo') }}</label>
                    <div class="col-md-10">
                        <div class="input-group" data-toggle="aizuploader" data-type="image">
                            <div class="input-group-prepend">
                                <div class="input-group-text bg-soft-secondary font-weight-medium rounded-0">
                                    {{ translate('Browse') }}</div>
                            </div>
                            <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                            <input type="hidden" name="photo" class="selected-files">
                        </div>
                        <div class="file-preview box sm">
                        </div>
                    </div>
                </div>
                <!-- Password-->
                <div class="form-group row">
                    <label class="col-md-2 col-form-label fs-14">{{ translate('Your Password') }}</label>
                    <div class="col-md-10">
                        <input type="password" class="form-control rounded-0" placeholder="{{ translate('New Password') }}"
                            name="new_password">
                    </div>
                </div>
                <!-- Confirm Password-->
                <div class="form-group row">
                    <label class="col-md-2 col-form-label fs-14">{{ translate('Confirm Password') }}</label>
                    <div class="col-md-10">
                        <input type="password" class="form-control rounded-0"
                            placeholder="{{ translate('Confirm Password') }}" name="confirm_password">
                    </div>
                </div>
                <!-- Submit Button-->
                <div class="form-group mb-0 text-right">
                    <button type="submit"
                        class="btn btn-primary rounded-0 w-150px mt-3">{{ translate('Update Profile') }}</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Address -->
    <div class="card rounded-0 shadow-none border">
        <div class="card-header pt-4 border-bottom-0">
            <h5 class="mb-0 fs-18 fw-700 text-dark">{{ translate('Address') }}</h5>
        </div>
        <div class="card-body">
            @foreach (Auth::user()->addresses as $key => $address)
                <div class="">
                    <div class="border p-4 mb-4 position-relative">
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary">{{ translate('Address') }}:</span>
                            <span class="col-md-8 text-dark">{{ $address->address }}</span>
                        </div>
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary">{{ translate('Postal Code') }}:</span>
                            <span class="col-md-10 text-dark">{{ $address->postal_code }}</span>
                        </div>
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary">{{ translate('City') }}:</span>
                            <span class="col-md-10 text-dark">{{ optional($address->city)->name }}</span>
                        </div>
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary">{{ translate('State') }}:</span>
                            <span class="col-md-10 text-dark">{{ optional($address->state)->name }}</span>
                        </div>
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary">{{ translate('Country') }}:</span>
                            <span class="col-md-10 text-dark">{{ optional($address->country)->name }}</span>
                        </div>
                        <div class="row fs-14 mb-2 mb-md-0">
                            <span class="col-md-2 text-secondary text-secondary">{{ translate('Phone') }}:</span>
                            <span class="col-md-10 text-dark">{{ $address->phone }}</span>
                        </div>
                        @if ($address->set_default)
                            <div class="absolute-md-top-right pt-2 pt-md-4 pr-md-5">
                                <span class="badge badge-inline badge-secondary-base text-white p-3 fs-12"
                                    style="border-radius: 25px; min-width: 80px !important;">{{ translate('Default') }}</span>
                            </div>
                        @endif
                        <div class="dropdown position-absolute right-0 top-0 pt-4 mr-1">
                            <button class="btn bg-gray text-white px-1 py-1" type="button" data-toggle="dropdown">
                                <i class="la la-ellipsis-v"></i>
                            </button>
                            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" onclick="edit_address('{{ $address->id }}')">
                                    {{ translate('Edit') }}
                                </a>
                                @if (!$address->set_default)
                                    <a class="dropdown-item"
                                        href="{{ route('addresses.set_default', $address->id) }}">{{ translate('Make This Default') }}</a>
                                @endif
                                <a class="dropdown-item"
                                    href="{{ route('addresses.destroy', $address->id) }}">{{ translate('Delete') }}</a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
            <!-- Add New Address -->
            <div class="" onclick="add_new_address()">
                <div class="border p-3 mb-3 c-pointer text-center bg-light has-transition hov-bg-soft-light">
                    <i class="la la-plus la-2x"></i>
                    <div class="alpha-7 fs-14 fw-700">{{ translate('Add New Address') }}</div>
                </div>
            </div>
        </div>
    </div>


    <!-- Change Email -->
    <form action="{{ route('user.change.email') }}" method="POST">
        @csrf
        <div class="card rounded-0 shadow-none border">
            <div class="card-header pt-4 border-bottom-0">
                <h5 class="mb-0 fs-18 fw-700 text-dark">{{ translate('Change your email') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <label class="fs-14">{{ translate('Your Email') }}</label>
                    </div>
                    <div class="col-md-10">
                        <div class="input-group mb-3">
                            <input type="email" class="form-control rounded-0"
                                placeholder="{{ translate('Your Email') }}" name="email"
                                value="{{ Auth::user()->email }}" />
                            <div class="input-group-append">
                                <button type="button" class="btn btn-outline-secondary new-email-verification">
                                    <span class="d-none loading">
                                        <span class="spinner-border spinner-border-sm" role="status"
                                            aria-hidden="true"></span>{{ translate('Sending Email...') }}
                                    </span>
                                    <span class="default">{{ translate('Verify') }}</span>
                                </button>
                            </div>
                        </div>
                        <div class="form-group mb-0 text-right">
                            <button type="submit"
                                class="btn btn-primary rounded-0 w-150px mt-3">{{ translate('Update Email') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    {{-- Update Documents --}}
    @if (Auth::user()->is_wholeseller == '1')
        <form id="update_documents" action="{{ route('user.update.documents') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0 h6">{{ translate('Update or View Documents') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="document1new" class="form-label">Upload (Drug License, GST)</label>
                            {{-- custom input design --}}
                            <div class="custom-file">
                                <input type="file" name="document1new" id="document1new" class="custom-file-input document1new"
                                    accept=".xls, .xlsx, .doc, .docx, .pdf, image/*">
                                <input type="file" name="document2new" id="document2new" class="custom-file-input document1new"
                                    accept=".xls, .xlsx, .doc, .docx, .pdf, image/*">
                                <label class="custom-file-label document1new2" for="document1new2">Choose file</label>
                            </div>
                            <input value="{{ Auth::user()->doc1 }}" type="hidden" name="documentold1" id="documentold1">
                            <input value="{{ Auth::user()->doc2 }}" type="hidden" name="documentold2" id="documentold2">
                            <ul id="document1newList"></ul>
                            @if (Auth::user()->doc1 != '')
                                <a class="font-weight-bold text-blue mt-2"
                                    href="{{ url('public/storage/uploads/documents/' . Auth::user()->doc1) }}" target="_blank"
                                    rel="noopener noreferrer">
                                    View Document 1 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                            @if (Auth::user()->doc2 != '')
                            &nbsp;&nbsp;&nbsp;
                                <a class="font-weight-bold text-blue mt-2"
                                    href="{{ url('public/storage/uploads/documents/' . Auth::user()->doc2) }}" target="_blank"
                                    rel="noopener noreferrer">
                                    View Document 2 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div>

                        {{-- <div class="col-md-4 mb-3">
                            <label for="document11" class="form-label">Upload Document 1</label>
                            <input type="file" name="document11" id="document11"
                                class="form-control-sm" accept=".xls, .xlsx, .doc, .docx, .pdf" style="font-size: 0.8rem; padding: 0.3rem 0;">
                            <input value="{{ Auth::user()->doc1 }}" type="hidden" name="documentold1" id="documentold1">
                            @if (Auth::user()->doc1 != '')
                                <a class="font-weight-bold text-blue mt-2" href="{{ url('storage/uploads/documents/' . Auth::user()->doc1) }}" target="_blank" rel="noopener noreferrer">
                                    View Document 1 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="document2" class="form-label">Upload Document 2</label>
                            <input type="file" name="document2" id="document2"
                                class="form-control-sm" accept=".xls, .xlsx, .doc, .docx, .pdf" style="font-size: 0.8rem; padding: 0.3rem 0;">
                            <input value="{{ Auth::user()->doc2 }}" type="hidden" name="documentold2" id="documentold2">
                            @if (Auth::user()->doc2 != '')
                                <a class="font-weight-bold text-blue mt-2" href="{{ url('storage/uploads/documents/' . Auth::user()->doc2) }}" target="_blank" rel="noopener noreferrer">
                                    View Document 2 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="document3" class="form-label">Upload Document 3</label>
                            <input type="file" name="document3" id="document3"
                                class="form-control-sm" accept=".xls, .xlsx, .doc, .docx, .pdf" style="font-size: 0.8rem; padding: 0.3rem 0;">
                            <input value="{{ Auth::user()->doc3 }}" type="hidden" name="documentold3" id="documentold3">
                            @if (Auth::user()->doc3 != '')
                                <a class="font-weight-bold text-blue mt-2" href="{{ url('storage/uploads/documents/' . Auth::user()->doc3) }}" target="_blank" rel="noopener noreferrer">
                                    View Document 3 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="document4" class="form-label">Upload Document 4</label>
                            <input type="file" name="document4" id="document4"
                                class="form-control-sm" accept=".xls, .xlsx, .doc, .docx, .pdf" style="font-size: 0.8rem; padding: 0.3rem 0;">
                            <input value="{{ Auth::user()->doc4 }}" type="hidden" name="documentold4" id="documentold4">
                            @if (Auth::user()->doc4 != '')
                                <a class="font-weight-bold text-blue mt-2" href="{{ url('storage/uploads/documents/' . Auth::user()->doc4) }}" target="_blank" rel="noopener noreferrer">
                                    View Document 4 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="document5" class="form-label">Upload Document 5</label>
                            <input type="file" name="document5" id="document5"
                                class="form-control-sm" accept=".xls, .xlsx, .doc, .docx, .pdf" style="font-size: 0.8rem; padding: 0.3rem 0;">
                            <input value="{{ Auth::user()->doc5 }}" type="hidden" name="documentold5" id="documentold5">
                            @if (Auth::user()->doc5 != '')
                                <a class="font-weight-bold text-blue mt-2" href="{{ url('storage/uploads/documents/' . Auth::user()->doc5) }}" target="_blank" rel="noopener noreferrer">
                                    View Document 5 <i class="fa-solid fa-eye"></i>
                                </a>
                            @endif
                        </div> --}}
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-primary">{{ translate('Update Documents') }}</button>
                    </div>
                </div>
            </div>
        </form>
    @endif
@endsection

@section('modal')
    <!-- Address modal -->
    @include('frontend.partials.address.address_modal')
@endsection

@section('script')
    @include('frontend.partials.address.address_js')

    <script type="text/javascript">
    $(document).ready(function() {
        $('.new-email-verification').on('click', function() {
            $(this).find('.loading').removeClass('d-none');
            $(this).find('.default').addClass('d-none');
            var email = $("input[name=email]").val();

            $.post('{{ route('user.new.verify') }}', {
                _token: '{{ csrf_token() }}',
                email: email
            }, function(data) {
                data = JSON.parse(data);
                $('.default').removeClass('d-none');
                $('.loading').addClass('d-none');
                if (data.status == 2)
                    AIZ.plugins.notify('warning', data.message);
                else if (data.status == 1)
                    AIZ.plugins.notify('success', data.message);
                else
                    AIZ.plugins.notify('danger', data.message);
            });
        });

        var file_upload_count_new = 2;
        var document1_files_new = [];
        var is_submitted_new = false;

        $('.document1new2').on('click', function() {
            if ($('#document1new').val() == '') {
                $('#document1new').trigger('click');
            } else {
                $('#document2new').trigger('click');
            }
        });

        $('.document1new').on('change', function() {
            const file = this.files[0];
            if (file) {
                // Check file name exists
                const fileNameExists = document1_files_new.some(existingFile => existingFile.name === file.name);
                if (fileNameExists) {
                    AIZ.plugins.notify('warning', 'File already exists.');
                    return;
                }
                if (document1_files_new.length >= file_upload_count_new) {
                    AIZ.plugins.notify('warning', `You can only upload ${file_upload_count_new} files.`);
                    return;
                }
                var document_id = 'document1new';
                if ($(this).attr('id') === 'document2new') {
                    document_id = 'document2new';
                }
                document1_files_new.push(file);
                $('#document1newList').append(
                    `<li class="list-group-item d-flex justify-content-between align-items-center">
                            ${file.name}
                            <button type="button" class="btn btn-danger btn-sm remove-file" data-document="${document_id}" data-file="${file.name}">Remove</button>
                        </li>`
                );
            }
        });

        $(document).on('click', '#document1newList .remove-file', function() {
            const fileName = $(this).data('file');
            const documentId = $(this).data('document');
            document1_files_new = document1_files_new.filter(file => file.name !== fileName);
            $(this).closest('li').remove();
            if (documentId === 'document1new') {
                $('#document1new').val(''); // Clear the input field
            } else if (documentId === 'document2new') {
                $('#document2new').val(''); // Clear the input field
            }
        });
        
    });
    </script>

    @if (get_setting('google_map') == 1)
        @include('frontend.partials.google_map')
    @endif
@endsection
