<?php

/*
|--------------------------------------------------------------------------
| OTP Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\FeedBackController;
use App\Http\Controllers\OTPVerificationController;
use App\Http\Controllers\OTPController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\SmsTemplateController;

//Verofocation phone
Route::controller(OTPVerificationController::class)->group(function () {
    Route::get('/verification', 'verification')->name('verification');
    Route::post('/verification', 'verify_phone')->name('verification.submit');
    Route::get('/verification/phone/code/resend', 'resend_verificcation_code')->name('verification.phone.resend');

    //Forgot password phone
    Route::get('/password/phone/reset', 'show_reset_password_form')->name('password.phone.form');
    Route::post('/password/reset/submit', 'reset_password_with_code')->name('password.update.phone');

    // Send OTP
    Route::post('/send-otp', 'sendOtp')->name('send-otp');
    Route::get('/otp-verification', 'otpVerificationPage')->name('otp-verification-page');
    Route::get('/resend-otp/{phone}', 'resendOtp')->name('resend-otp');
    Route::post('/validate-otp-code', 'validateOtpCode')->name('validate-otp-code');
});

//Admin
Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'admin']], function () {
    Route::controller(OTPController::class)->group(function () {
        Route::get('/otp-login-configuration', 'loginConfigure')->name('otp.login_configuration');
        Route::get('/otp-configuration', 'configure_index')->name('otp.configconfiguration');
        Route::post('/otp-configuration/update/activation', 'updateActivationSettings')->name('otp_configurations.update.activation');
        Route::post('/otp-credentials-update', 'update_credentials')->name('update_credentials');
    });
    //Messaging
    Route::controller(SmsController::class)->group(function () {
        Route::get('/sms', 'index')->name('sms.index');
        Route::post('/sms-send', 'send')->name('sms.send');
    });

    Route::controller(FeedBackController::class)->group(function () {
        Route::get('feedback', 'index')->name('feedback.index');
        Route::post('/feedback-send', 'send')->name('feedback.send');
    });

    Route::resource('sms-templates', SmsTemplateController::class);
});
