<?php $__env->startSection('meta'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="mb-4 pt-3">
    <div class="container">
        <div class="bg-white py-3">
            <div class="row">
                <!-- Product Image Gallery -->
                <div class="col-md-8">
                    <?php echo $__env->make('preorder.frontend.product_details.image_gallery', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </div>

                <!-- Product Details -->
                <div class="col-md-4">
                    <?php echo $__env->make('preorder.frontend.product_details.details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Price    -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.price_section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                    <?php echo $__env->make('preorder.frontend.place_preorder', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Review    -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.review', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
            <div class="row">
                <!-- Product Image Gallery -->
                <div class="col-md-8 mb-4">
                    <!-- Description-->
                    <?php echo $__env->make('preorder.frontend.product_details.description', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- more products-->
                    <?php if($more_products !== null && count($more_products) > 0): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.preorder_products', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- Reviews & Ratings -->
                    <div id="pre_review_ratings">

                    </div>
                    <?php echo $__env->make('preorder.frontend.product_details.product_reviews', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Frequently Bought products -->
                    <?php if($fq_bought_products !== null && count($fq_bought_products) > 0): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.frequently_bought_products', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- Seller Info -->
                    <?php echo $__env->make('preorder.frontend.product_details.seller_info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Product Query -->
                    <div id="pre_product_queries">

                    </div>
                    <?php echo $__env->make('preorder.frontend.product_details.product_queries', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Related Products  -->
                    <?php if( count(\App\Models\Product::inRandomOrder()->get()) > 0): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.related_products', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- Top Selling Products  -->
                    <?php if( count(\App\Models\Product::inRandomOrder()->get()) > 0): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.top_selling', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                </div>

                <!-- Product Details -->
                <div class="col-md-4">
                    <!-- Coupon    -->
                    <?php if($product->is_coupon): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.right.coupon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- brand   -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.brand', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- shop   -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.shop', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Shipping   -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.shipping', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- Refund   -->
                    <?php if($product->is_refundable): ?>
                    <?php echo $__env->make('preorder.frontend.product_details.right.refund', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php endif; ?>
                    <!-- icon-section   -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.icon_section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- faq   -->
                    <?php echo $__env->make('preorder.frontend.product_details.right.faq', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<!-- Image Modal -->
<div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
        <div class="modal-content position-relative">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="p-4">
                <div class="size-300px size-lg-450px">
                    <img class="img-fit h-100 lazyload" src="<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>"
                        data-src=""
                        onerror="this.onerror=null;this.src='<?php echo e(static_asset('assets/img/placeholder.jpg')); ?>';">
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Conversation Modal -->
<div class="modal fade" id="product-conversation-modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-zoom product-modal" id="modal-size" role="document">
        <div class="modal-content" id="product-conversation-modal-content">
            
        </div>
    </div>
</div>

<!-- Product Review Modal -->
<div class="modal fade" id="product-review-modal">
    <div class="modal-dialog">
        <div class="modal-content" id="product-review-modal-content">

        </div>
    </div>
</div>

<!-- Size chart show Modal -->
<?php echo $__env->make('modals.size_chart_show_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>




<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script type="text/javascript">
    window.onload = function() {
        window.scrollTo(0, 0); // Scrolls to the top of the page
    };

</script>
<script type="text/javascript">
    $(document).ready(function() {
            getVariantPrice();
        });

        function CopyToClipboard(e) {
            var url = $(e).data('url');
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val(url).select();
            try {
                document.execCommand("copy");
                AIZ.plugins.notify('success', '<?php echo e(translate('Link copied to clipboard')); ?>');
            } catch (err) {
                AIZ.plugins.notify('danger', '<?php echo e(translate('Oops, unable to copy')); ?>');
            }
            $temp.remove();
        }


        // Pagination using ajax
        $(window).on('hashchange', function() {
            if(window.history.pushState) {
                window.history.pushState('', '/', window.location.pathname);
            } else {
                window.location.hash = '';
            }
        });

        $(document).ready(function() {
            $(document).on('click', '.product-queries-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'query', 'queries-area');
                e.preventDefault();
            });
        });

        $(document).ready(function() {
            $(document).on('click', '.product-reviews-pagination .pagination a', function(e) {
                getPaginateData($(this).attr('href').split('page=')[1], 'review', 'reviews-area');
                e.preventDefault();
            });
        });

        function getPaginateData(page, type, section) {
            $.ajax({
                url: '?page=' + page,
                dataType: 'json',
                data: {type: type},
            }).done(function(data) {
                $('.'+section).html(data);
                location.hash = page;
            }).fail(function() {
                alert('Something went worng! Data could not be loaded.');
            });
        }
        // Pagination end

        function showImage(photo) {
            $('#image_modal img').attr('src', photo);
            $('#image_modal img').attr('data-src', photo);
            $('#image_modal').modal('show');
        }

        function bid_modal(){
            <?php if(isCustomer() || isSeller()): ?>
                $('#bid_for_detail_product').modal('show');
          	<?php elseif(isAdmin()): ?>
                AIZ.plugins.notify('warning', '<?php echo e(translate("Sorry, Only customers & Sellers can Bid.")); ?>');
            <?php else: ?>
                $('#login_modal').modal('show');
            <?php endif; ?>
        }


        // Preorder Product Review
        function product_review(product_id) {
            <?php if(isCustomer()): ?>
                <?php if($review_status == 1): ?>
                    $.post('<?php echo e(route('preorder.product_review_modal')); ?>', {
                        _token: '<?php echo e(@csrf_token()); ?>',
                        product_id: product_id
                    }, function(data) {
                        $('#product-review-modal-content').html(data);
                        $('#product-review-modal').modal('show', {
                            backdrop: 'static'
                        });
                        AIZ.extra.inputRating();
                    });
                <?php else: ?>
                    AIZ.plugins.notify('warning', '<?php echo e(translate("Sorry, You need to buy this product to give review.")); ?>');
                <?php endif; ?>
            <?php elseif(Auth::check() && !isCustomer()): ?>
                AIZ.plugins.notify('warning', '<?php echo e(translate("Sorry, Only customers can give review.")); ?>');
            <?php else: ?>
                $('#login_modal').modal('show');
            <?php endif; ?>
        }

        // function showPlacePreorderModal(){
        // alert('ok');
        //     if(!$('#modal-size').hasClass('modal-lg')){
        //         $('#modal-size').addClass('modal-lg');
        //     }
        //     $('#placePreorder').modal();
        //     $('.c-preloader').show();
        // }


        function show_conversation_modal(product_id) {
            <?php if(isCustomer()): ?>
                $.post('<?php echo e(route('preorder.conversation_modal')); ?>', {
                    _token: '<?php echo e(@csrf_token()); ?>',
                    product_id: product_id
                }, function(data) {
                    $('#product-conversation-modal-content').html(data);
                    $('#product-conversation-modal').modal('show', {
                        backdrop: 'static'
                    });
                });
            <?php elseif(Auth::check() && !isCustomer()): ?>
                AIZ.plugins.notify('warning', '<?php echo e(translate("Sorry, Only customers can give review.")); ?>');
            <?php else: ?>
                $('#login_modal').modal('show');
            <?php endif; ?>
        }

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/akshathealthcare/public_html/resources/views/preorder/frontend/product_details.blade.php ENDPATH**/ ?>