<div class="section order-summary">
    <h2>Order Summary</h2>

    <?php
        $subtotal_for_min_order_amount = 0;
        $subtotal = 0;
        $tax = 0;
        $product_shipping_cost = 0;
        $shipping = 0;
        $coupon_code = null;
        $coupon_discount = 0;
        $total_point = 0;
        $is_cash_on_delivery = true;
    ?>
    <!-- Product Details with Discount Badge -->
    <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $product = $cart->product;
            $quantity = floatval($cart->quantity);
            // $product_variation_price = product_variation_discount($product, $cart->variation);

            // $discount = (isset($product_variation_price['total']) ? $product_variation_price['total'] : 0) * $quantity;
            $discount = $cart->discount;
            $coupon_discount += $discount;

            // $product_price = (isset($product_variation_price['price']) ? $product_variation_price['price'] : 0) * $quantity;
            $product_price = cart_product_price($cart, $product, false, false) * $cart->quantity;
            $subtotal += $product_price;
            $subtotal_for_min_order_amount += $product_price;

            $i_tax = product_tax($product, $cart->variation) * $quantity;
            $tax += $i_tax;

            $shipping += $cart->shipping_cost;

            if (empty($coupon_code) && $cart->coupon_code && $cart->coupon_applied) {
                $coupon_code = $cart->coupon_code;
            }

            $product_amount = round($product_price);
            if ($product_price > $discount) {
                $product_amount = round($product_price - $discount);
            }
            $is_cash_on_delivery = $product->cash_on_delivery;

            $show_discount_label = true;
            if (isset($cart->coupon)) {
                if ($cart->coupon->type == 'cart_base') {
                    $show_discount_label = false;
                }
            }

        ?>
        <div class="product-item">
            <div>
                <?php if($discount > 0 && $show_discount_label): ?>
                    <span class="discount-badge"><?php echo e(single_price($discount)); ?> OFF</span>
                <?php endif; ?>
                <span><?php echo e($product->name); ?></span>
            </div>
            <div class="quantity-controls">
                <button onclick="updateQuantity(this, <?php echo e($cart->id); ?>, -1)">-</button>
                <span class="quantity-product"><?php echo e($quantity); ?></span>
                <button onclick="updateQuantity(this, <?php echo e($cart->id); ?>, 1)">+</button>
                <span class="price-product"><?php echo e(single_price($product_amount)); ?></span>
                <small>(Original: <?php echo e(single_price($product_price)); ?>)</small>
            </div>
            <span
                title="Remove <?php echo e($product->name); ?> From Cart"
                data-owner_id="<?php echo e($cart->owner_id); ?>"
                data-productid="<?php echo e($product->id); ?>"
                class="cross-mark deleteproduct"
                style="cursor: pointer;">
                <i class="fa-solid fa-xmark"></i>
            </span>

        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if(get_setting('coupon_system') == 1): ?>
        <!-- Coupon Section with Badge -->
        <div class="coupon-section">
            <input type="text" id="coupon-code" <?php if($coupon_discount > 0 && $coupon_code): echo 'readonly'; endif; ?> placeholder="Enter coupon code" value="<?php echo e($coupon_code); ?>" />
            <?php if($coupon_discount > 0 && $coupon_code): ?>
                <button type="button" id="coupon-remove">Remove Coupon</button>
            <?php else: ?>
                <button type="button" id="coupon-apply">Apply Coupon</button>
            <?php endif; ?>
            <span class="coupon-badge">%</span>
        </div>
    <?php endif; ?>
    <!-- Price Details -->
    <div class="price-details">
        <div class="price-row">
            
            <span>Sub Total</span>
            <span id="subtotal"><?php echo e(single_price($subtotal)); ?></span>
        </div>
        <div class="price-row">
            <span>Total Discount</span>
            <span id="discount">-<?php echo e(single_price($coupon_discount)); ?></span>
        </div>
        <div class="price-row">
            <span>Shipping Fee</span>
            <span id="shipping"><?php echo e(single_price($shipping)); ?></span>
        </div>
        <?php if($tax > 0): ?>
            <div class="price-row">
                <span>Tax</span>
                <span id="tax"><?php echo e(single_price($tax)); ?></span>
            </div>
        <?php endif; ?>
        <?php if(Auth::check() && Auth::user()->balance > 0): ?>
            <div class="price-row wallet">
                <span>Wallet Balance (<?php echo e(single_price(Auth::user()->balance)); ?>)</span>
                <span id="wallet">₹0</span>
                <input type="number" id="wallet_used_amount" class="wallet-input" min="0" max="1000" placeholder="Add" value="<?php echo e(isset($wallet_used_amount) ? $wallet_used_amount : ''); ?>" onchange="updateWallet()" <?php if(Auth::user()->balance <= 0): echo 'readonly'; endif; ?> />
            </div>
        <?php endif; ?>
        <?php
            $total = $subtotal + $tax + $shipping;
            $club_point = 0;
            if (Session::has('club_point')) {
                $club_point = Session::get('club_point');
                $total -= $club_point;
            }
            if ($coupon_discount > 0) {
                $total -= $coupon_discount;
            }
        ?>
        <div class="price-row">
            <span>Total (<span style="font-size: 13px;">Inclusive of all Taxes</span>)</span>
            <span id="total"><?php echo e(single_price($total)); ?></span>
        </div>
    </div>

    <!-- Payment Methods -->
    <div class="payment-methods">
        <div class="form-group">
            <label for="payment">Payment Method</label>
            <select id="payment_method" name="payment_method" onchange="updatePaymentType(this)" class="aiz-selectpicker w-100">
                <option value="">Select Payment Method</option>
                <?php $__currentLoopData = get_payment_methods(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($method); ?>" <?php if(old('payment_method', isset($payment_method) ? $payment_method : '') === $method): echo 'selected'; endif; ?>><?php echo e(ucwords(translate($method))); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($is_cash_on_delivery): ?>
                    <option value="cash_on_delivery"><?php echo e(translate('Cash On Delivery')); ?></option>
                <?php endif; ?>
                <?php if((get_setting('wallet_system') == 1) && (Auth::check() && Auth::user()->balance > 0)): ?>
                    <option value="wallet"><?php echo e(translate('Wallet')); ?></option>
                <?php endif; ?>
            </select>
        </div>
    </div>

    <!-- Agree Box -->
    <div class="pt-2 fs-14 d-flex mt-2">
        <label class="aiz-checkbox">
            <input type="checkbox" required id="agree_checkbox" onchange="agreeCheckbox(this)">
            <span class="aiz-square-check"></span>
            <span><?php echo e(translate('I agree to the')); ?></span>
        </label>
        <a href="<?php echo e(route('terms')); ?>"
            class="fw-700 ml-1"><?php echo e(trim(translate('terms and conditions'))); ?></a>,
        <a href="<?php echo e(route('returnpolicy')); ?>"
            class="fw-700 mx-1"><?php echo e(trim(translate('return policy'))); ?></a> &
        <a href="<?php echo e(route('privacypolicy')); ?>"
            class="fw-700 ml-1"><?php echo e(trim(translate('privacy policy'))); ?></a>
    </div>
    <div class="mt-4">
        <!-- Pay Now Button -->
        <button type="button" id="submitOrderBtn" class="pay-now" onclick="submitOrder(this)" disabled>
            <?php echo e(translate('Pay Now')); ?>

        </button>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    $(document).ready(function() {
        $(document).on('click', '.deleteproduct', function() {
            let owner_id = $(this).data('owner_id');
            let productid = $(this).data('productid');

            fetch(`deleteproductcheckout/${owner_id}/${productid}`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Request failed');
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        AIZ.plugins.notify('success', data.message);
                        setTimeout(() => {
                            window.location.reload();
                        }, 1000)
                    } else {
                        AIZ.plugins.notify('error', data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Something went wrong while deleting the product.');
                });
        });
    });
</script>
<?php /**PATH /home2/akshathealthcare/public_html/resources/views/frontend/partials/cart/order-summary.blade.php ENDPATH**/ ?>