<div class="card-header mb-2">
    <h5 class="mb-0 h6"><?php echo e(translate('Add Your Product Base Coupon')); ?></h5>
</div>
<div class="form-group row">
    <label class="col-lg-3 control-label" for="code"><?php echo e(translate('Coupon code')); ?></label>
    <div class="col-lg-9">
        <input type="text" placeholder="<?php echo e(translate('Coupon code')); ?>" id="code" name="code" value="<?php echo e($coupon->code); ?>" class="form-control" required>
    </div>
</div>
<div class="product-choose-list">
    <div class="product-choose">
        <div class="form-group row">
            <label class="col-lg-3 control-label" for="name"><?php echo e(translate('Product')); ?></label>
            <div class="col-lg-9">
                <select name="product_ids[]" class="form-control product_id aiz-selectpicker" data-live-search="true" data-selected-text-format="count" required multiple>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($product->id); ?>"
                            <?php $__currentLoopData = json_decode($coupon->details); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($details->product_id == $product->id): ?>
                                    selected
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            ><?php echo e($product->getTranslation('name')); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>
    </div>
</div>
<?php
  $start_date = date('m/d/Y', $coupon->start_date);
  $end_date = date('m/d/Y', $coupon->end_date);
?>
<div class="form-group row">
    <label class="col-sm-3 control-label" for="start_date"><?php echo e(translate('Date')); ?></label>
    <div class="col-sm-9">
      <input type="text" class="form-control aiz-date-range" value="<?php echo e($start_date .' - '. $end_date); ?>" name="date_range" placeholder="<?php echo e(translate('Select Date')); ?>">
    </div>
</div>

<div class="form-group row">
   <label class="col-lg-3 col-from-label"><?php echo e(translate('Discount')); ?></label>
   <div class="col-lg-7">
       <input type="number" lang="en" min="0" step="0.01" placeholder="<?php echo e(translate('Discount')); ?>" value="<?php echo e($coupon->discount); ?>" name="discount" class="form-control" required>

   </div>
   <div class="col-lg-2">
       <select class="form-control aiz-selectpicker" name="discount_type">
           <option value="amount" <?php if($coupon->discount_type == 'amount'): ?> selected  <?php endif; ?>><?php echo e(translate('Amount')); ?></option>
           <option value="percent" <?php if($coupon->discount_type == 'percent'): ?> selected  <?php endif; ?>><?php echo e(translate('Percent')); ?></option>
       </select>
   </div>
</div>

<script type="text/javascript">

    $(document).ready(function(){
        $('.aiz-date-range').daterangepicker();
        AIZ.plugins.bootstrapSelect('refresh');
    });

</script>
<?php /**PATH /home2/akshathealthcare/public_html/resources/views/partials/coupons/product_base_coupon_edit.blade.php ENDPATH**/ ?>