<?php $__env->startSection('content'); ?>

<div class="aiz-titlebar text-left mt-2 mb-3">
    <div class="align-items-center">
        <h1 class="h3">
            <?php echo e(isset($wholeseller) ? translate('All Wholesellers') : translate('All Customers')); ?>

        </h1>        
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_customer')): ?>
        <div class="col text-right">
            <?php if(isset($wholeseller)): ?>
                <a href="<?php echo e(route('wholesellers.create')); ?>" class="btn btn-circle btn-info">
                    <span><?php echo e(translate('Add New Wholeseller')); ?></span>
                </a>
            <?php else: ?>
                <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-circle btn-info">
                    <span><?php echo e(translate('Add New Customer')); ?></span>
                </a>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<p>
    <span class="bg-danger d-inline-block h-10px rounded-2 w-10px" ></span> <?php echo e(translate('This color indicates that the customer is marked as blocked.')); ?>

    <br>
    <span class="bg-info d-inline-block h-10px rounded-2 w-10px"></span> <?php echo e(translate('This color indicates that the customer is marked as suspicious.')); ?>

</p>

<div class="card">
    <form class="" id="sort_customers" action="" method="GET">
        <div class="card-header row gutters-5">
            <div class="col">
                <h5 class="mb-0 h6">
                    <?php echo e(isset($wholeseller) ? translate('Wholesellers') : translate('Customers')); ?>

                </h5>
            </div>

            <div class="dropdown mb-2 mb-md-0">
                <button class="btn border dropdown-toggle" type="button" data-toggle="dropdown">
                    <?php echo e(translate('Bulk Action')); ?>

                </button>
                <div class="dropdown-menu dropdown-menu-right">
                    <a class="dropdown-item confirm-alert" href="javascript:void(0)" data-target="#bulk-delete-modal"><?php echo e(translate('Delete selection')); ?></a>
                </div>
            </div>
            <div class="col-lg-2 ml-auto">
                <select class="form-control aiz-selectpicker" name="verification_status" onchange="sort_customers()" data-selected="<?php echo e($verification_status); ?>">
                    <option value=""><?php echo e(translate('Filter by Verification Status')); ?></option>
                    <option value="verified"><?php echo e(translate('Verified')); ?></option>
                    <option value="un_verified"><?php echo e(translate('Unverified')); ?></option>
                </select>
            </div>
            <div class="col-md-3">
                <div class="form-group mb-0">
                    <input type="text" class="form-control" id="search" name="search" <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?> placeholder="<?php echo e(translate('Type email or name & Enter')); ?>">
                </div>
            </div>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>
                                <div class="form-group">
                                    <div class="aiz-checkbox-inline">
                                        <label class="aiz-checkbox">
                                            <input type="checkbox" class="check-all">
                                            <span class="aiz-square-check"></span>
                                        </label>
                                    </div>
                                </div>
                            </th>
                            <th><?php echo e(translate('Name')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Email Address')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Phone')); ?></th>
                            <?php if(isset($wholeseller)): ?>
                                <th data-breakpoints="lg"><?php echo e(translate('GST Number')); ?></th>
                                <th data-breakpoints="lg"><?php echo e(translate('Drug License Number')); ?></th>
                            <?php endif; ?>
                            <th data-breakpoints="lg"><?php echo e(translate('Address')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Wallet Balance')); ?></th>
                            <th data-breakpoints="lg"><?php echo e(translate('Verification Status')); ?></th>
                            <th><?php echo e(translate('Options')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($user): ?>
                                <tr>
                                    <td>
                                        <div class="form-group">
                                            <div class="aiz-checkbox-inline">
                                                <label class="aiz-checkbox">
                                                    <input type="checkbox" class="check-one" name="id[]" value="<?php echo e($user->id); ?>">
                                                    <span class="aiz-square-check"></span>
                                                </label>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex justify-content-start align-items-center user-name">
                                            <div class="avatar-wrapper">
                                                <div class="avatar avatar-xs me-4"><img
                                                        src="<?php echo e(get_user_avatar($user)); ?>"
                                                        alt="User Avatar" class="rounded-circle"></div>
                                            </div>
                                            <div class="d-flex flex-column ml-2">
                                                <span class="fw-medium">
                                                    <p
                                                        class="p-0 mb-0 <?php if($user->banned == 1): ?> text-danger <?php elseif($user->is_suspicious == 1): ?> text-info <?php endif; ?>">
                                                        <?php if($user->banned == 1): ?>
                                                            <i class="las la-ban las" aria-hidden="true"></i>
                                                        <?php elseif($user->is_suspicious == 1): ?>
                                                            <i class="las la-exclamation-circle" aria-hidden="true"></i>
                                                        <?php endif; ?>
                                                        <?php echo e($user->name); ?>

                                                    </p>
                                                </span>
                                                <small><?php echo e($user->email); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->phone); ?></td>
                                    <?php if(isset($wholeseller)): ?>
                                        <td><?php echo e($user->gst_no ?? 'N/A'); ?></td>
                                        <td><?php echo e($user->drug_license_no ?? 'N/A'); ?></td>
                                    <?php endif; ?>
                                    <td>
                                        <?php echo e($user->address); ?>

                                    </td>
                                    <td><?php echo e(single_price($user->balance)); ?></td>
                                    <td>
                                        <?php if($user->email_verified_at != null): ?>
                                            <span class="badge badge-inline badge-success"><?php echo e(translate('Verified')); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-inline badge-warning"><?php echo e(translate('Unverified')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="d-flex">
                                        <!--<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_customer')): ?>-->
                                        <!--    <a href="<?php echo e(isset($wholeseller) ? route('wholesellers.edit', encrypt($user->id)) : route('customers.edit', encrypt($user->id))); ?>" -->
                                        <!--       class="btn btn-soft-primary btn-icon btn-circle btn-sm" -->
                                        <!--       title="<?php echo e(isset($wholeseller) ? translate('Edit this Wholeseller') : translate('Edit this Customer')); ?>">-->
                                        <!--        <i class="las la-edit"></i>-->
                                        <!--    </a>-->
                                        <!--<?php endif; ?>-->
                                        
                                        <a href="<?php echo e(isset($wholeseller) ? route('wholesellers.edit', encrypt($user->id)) : route('customers.edit', encrypt($user->id))); ?>" 
                                           class="btn btn-soft-primary btn-icon btn-circle btn-sm mr-2" 
                                           title="<?php echo e(isset($wholeseller) ? translate('Edit this Wholeseller') : translate('Edit this Customer')); ?>">
                                            <i class="las la-edit"></i>
                                        </a>
                                        
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('login_as_customer')): ?>
                                            <?php if($user->email_verified_at != null): ?>
                                                <a href="<?php echo e(isset($wholeseller) ? route('wholesellers.login', encrypt($user->id)) : route('customers.login', encrypt($user->id))); ?>" 
                                                   class="btn btn-soft-primary btn-icon btn-circle btn-sm mr-2" 
                                                   title="<?php echo e(isset($wholeseller) ? translate('Log in as this Wholeseller') : translate('Log in as this Customer')); ?>">
                                                    <i class="las la-sign-in-alt"></i>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ban_customer')): ?>
                                            <?php if($user->banned != 1): ?>
                                                <a href="#" 
                                                   class="btn btn-soft-danger btn-icon btn-circle btn-sm mr-2" 
                                                   onclick="confirm_ban('<?php echo e(isset($wholeseller) ? route('wholesellers.ban', encrypt($user->id)) : route('customers.ban', encrypt($user->id))); ?>');" 
                                                   title="<?php echo e(isset($wholeseller) ? translate('Ban this Wholeseller') : translate('Ban this Customer')); ?>">
                                                    <i class="las la-user-slash"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="#" 
                                                   class="btn btn-soft-success btn-icon btn-circle btn-sm mr-2" 
                                                   onclick="confirm_unban('<?php echo e(isset($wholeseller) ? route('wholesellers.ban', encrypt($user->id)) : route('customers.ban', encrypt($user->id))); ?>');" 
                                                   title="<?php echo e(isset($wholeseller) ? translate('Unban this Wholeseller') : translate('Unban this Customer')); ?>">
                                                    <i class="las la-user-check"></i>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_customer')): ?>
                                            <a href="#" 
                                               class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete mr-2" 
                                               data-href="<?php echo e(isset($wholeseller) ? route('wholesellers.destroy', $user->id) : route('customers.destroy', $user->id)); ?>" 
                                               title="<?php echo e(isset($wholeseller) ? translate('Delete Wholeseller') : translate('Delete Customer')); ?>">
                                                <i class="las la-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>                                
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="aiz-pagination">
                <?php echo e($users->appends(request()->input())->links()); ?>

            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="confirm-ban">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h6"><?php echo e(translate('Confirmation')); ?></h5>
                <button type="button" class="close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(translate('Do you really want to ban this Customer?')); ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                <a type="button" id="confirmation" class="btn btn-primary"><?php echo e(translate('Proceed!')); ?></a>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="confirm-unban">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h6"><?php echo e(translate('Confirmation')); ?></h5>
                <button type="button" class="close" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p><?php echo e(translate('Do you really want to unban this Customer?')); ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-dismiss="modal"><?php echo e(translate('Cancel')); ?></button>
                <a type="button" id="confirmationunban" class="btn btn-primary"><?php echo e(translate('Proceed!')); ?></a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
    <?php echo $__env->make('modals.delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('modals.bulk_delete_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).on("change", ".check-all", function() {
            if(this.checked) {
                $('.check-one:checkbox').each(function() {
                    this.checked = true;
                });
            } else {
                $('.check-one:checkbox').each(function() {
                    this.checked = false;
                });
            }
        });

        function sort_customers() {
            $('#sort_customers').submit();
        }

        function confirm_ban(url) {
            if('<?php echo e(env('DEMO_MODE')); ?>' == 'On') {
                AIZ.plugins.notify('info', '<?php echo e(translate('Data can not change in demo mode.')); ?>');
                return;
            }
            $('#confirm-ban').modal('show', {backdrop: 'static'});
            document.getElementById('confirmation').setAttribute('href', url);
        }

        function confirm_unban(url) {
            if('<?php echo e(env('DEMO_MODE')); ?>' == 'On') {
                AIZ.plugins.notify('info', '<?php echo e(translate('Data can not change in demo mode.')); ?>');
                return;
            }
            $('#confirm-unban').modal('show', {backdrop: 'static'});
            document.getElementById('confirmationunban').setAttribute('href', url);
        }

        function bulk_delete() {
            var data = new FormData($('#sort_customers')[0]);
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('bulk-customer-delete')); ?>",
                type: 'POST',
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                success: function (response) {
                    if(response == 1) {
                        location.reload();
                    }
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/akshathealthcare/public_html/resources/views/backend/customer/customers/index.blade.php ENDPATH**/ ?>