<!-- New Address Modal -->
<div class="modal fade" id="change_shipping_address" tabindex="-1" role="dialog" aria-labelledby="change_shipping_addressModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="change_shipping_addressModalLabel"><?php echo e(translate('New Shipping Address')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form class="form-default" role="form" action="<?php echo e(route('purchase_history.shipping.update', encrypt($order->id))); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body c-scrollbar-light">
                    <div class="p-3">
                        
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Name')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <input type="text" class="form-control rounded-0" placeholder="<?php echo e(translate('Your Name')); ?>" name="name" required>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Email')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <input type="email" class="form-control rounded-0" placeholder="<?php echo e(translate('Your Email')); ?>" name="email" required>
                            </div>
                        </div>
                        <!-- Address -->
                        <div class="row">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Address')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <textarea class="form-control mb-3 rounded-0" placeholder="<?php echo e(translate('Your Address')); ?>" rows="2" name="address" required></textarea>
                            </div>
                        </div>

                        <!-- Country -->
                        <div class="row">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Country')); ?></label>
                            </div>
                            <?php $countries = get_active_countries(); ?>
                            <div class="col-md-10">
                                <div class="mb-3">
                                    <select class="form-control aiz-selectpicker rounded-0" data-live-search="true" data-placeholder="<?php echo e(translate('Select your country')); ?>" name="country_id" id="new_country" required>
                                        <option value=""><?php echo e(translate('Select your country')); ?></option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- State -->
                        <div class="row">
                            <div class="col-md-2">
                                <label><?php echo e(translate('State')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <select class="form-control mb-3 aiz-selectpicker rounded-0" data-live-search="true" name="state_id" id="new_state" required>
                                    <option value=""><?php echo e(translate('Select your state')); ?></option>
                                </select>
                            </div>
                        </div>

                        <!-- City -->
                        <div class="row">
                            <div class="col-md-2">
                                <label><?php echo e(translate('City')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <select class="form-control mb-3 aiz-selectpicker rounded-0" data-live-search="true" name="city_id" id="new_city" required>
                                    <option value=""><?php echo e(translate('Select your city')); ?></option>
                                </select>
                            </div>
                        </div>

                        <!-- Pincode -->
                        <div class="row">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Pincode')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <input type="text" class="form-control mb-3 rounded-0" placeholder="<?php echo e(translate('Pincode')); ?>" name="postal_code" id="new_pincode" required>
                                
                            </div>
                        </div>

                        <?php if(get_setting('google_map') == 1): ?>
                            <!-- Google Map -->
                            <div class="row mt-3 mb-3">
                                <input id="searchInput" class="controls" type="text" placeholder="<?php echo e(translate('Enter a location')); ?>">
                                <div id="map"></div>
                                <ul id="geoData">
                                    <li style="display: none;">Full Address: <span id="location"></span></li>
                                    <li style="display: none;">Postal Code: <span id="postal_code"></span></li>
                                    <li style="display: none;">Country: <span id="country"></span></li>
                                    <li style="display: none;">Latitude: <span id="lat"></span></li>
                                    <li style="display: none;">Longitude: <span id="lon"></span></li>
                                </ul>
                            </div>
                            <!-- Longitude -->
                            <div class="row">
                                <div class="col-md-2">
                                    <label><?php echo e(translate('Longitude')); ?></label>
                                </div>
                                <div class="col-md-10">
                                    <input type="text" class="form-control mb-3 rounded-0" id="longitude" name="longitude" readonly="">
                                </div>
                            </div>
                            <!-- Latitude -->
                            <div class="row">
                                <div class="col-md-2">
                                    <label><?php echo e(translate('Latitude')); ?></label>
                                </div>
                                <div class="col-md-10">
                                    <input type="text" class="form-control mb-3 rounded-0" id="latitude" name="latitude" readonly="">
                                </div>
                            </div>
                        <?php endif; ?>

                        <!-- Phone -->
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <label><?php echo e(translate('Phone')); ?></label>
                            </div>
                            <div class="col-md-10">
                                <input type="tel" id="phone-code" class="form-control rounded-0" placeholder="" name="phone" autocomplete="off" required>
                                <input type="hidden" name="country_code" value="">
                            </div>
                        </div>

                        <!-- Save button -->
                        <div class="form-group text-right">
                            <button type="submit" class="btn btn-primary rounded-0 w-150px"><?php echo e(translate('Save')); ?></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH /home2/akshathealthcare/public_html/resources/views/frontend/user/shipping_address_edit.blade.php ENDPATH**/ ?>