<?php $__env->startSection('page-styles'); ?>
<style>
    .order-summary-list {
        padding: 10px 0px;
        border-bottom: 1px solid #e4e4e4;
        margin: 0px 1px;
    }
    .order-summary-list .checkout-plus-minus button {
        height: 18px !important;!i;!;
        width: 18px !important;!i;!;
        line-height: 1px !important;!i;!;
        font-size: 12px;
        padding: 0px !important;!i;!;
    }
    
    .order-summary-list .checkout-plus-minus input {
        width: 30px !important;
        height: 18px;
    }
    
    .order-summary-list .discount-badge {
        position: absolute;
        left: 25px;
        top: -13px;
        /* width: 60px; */
        width: auto;
        height: 18px;
        padding: 0 6px;
        border-radius: 3px;
        color: #fff;
        font-size: 11px;
        background: red;
    }

    .order-summary .coupon-section {
        background-color: #f5f5f5;
        padding: 10px;
        margin: 16px 0px;
        border-radius: 5px;
    }

    .bg-light-success {
        background-color: #cff7b6 !important;
        color: #296603;
        font-weight: bold;
    }
</style>
<?php $__env->stopSection(); ?>
<div class="z-3 sticky-top-lg">
    
    <div class="card pt-2">
        <div class="card-header" style="border-bottom: none;padding-top: 10px;padding-bottom: 0px;">
            <h4><?php echo e(translate('Order Summary')); ?></h4>
        </div>
        <div class="card-body">
            <div class="order-summary">
                <?php
                    $subtotal_for_min_order_amount = 0;
                    $subtotal = 0;
                    $tax = 0;
                    $product_shipping_cost = 0;
                    $shipping = 0;
                    $coupon_code = null;
                    $coupon_discount = 0;
                    $total_point = 0;
                ?>
                <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $product = $cartItem->product ?: get_single_product($cartItem['product_id']);
                        $product_stock = $product->stocks->where('variant', $cartItem->variation)->first();
                        $current_stock = $product_stock ? $product_stock->qty : 0;
                        $product_price = cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                        if ($current_stock > 0) {
                            $subtotal_for_min_order_amount += $product_price;
                            $subtotal += $product_price;
                        }
                        
                        $i_tax = cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                        $tax += $i_tax;
                        
                        $shipping += $cartItem['shipping_cost'];
                        
                        $discount = 0;
                        if ((get_setting('coupon_system') == 1) && ($cartItem->coupon_applied == 1)) {
                            $discount = $cartItem->discount;
                            $coupon_code = $cartItem->coupon_code;
                            $coupon_discount += $discount;
                        }
                        $product_amount = number_format($product_price, 2, '.', '');
                        if ($product_price > $discount) {
                            $product_amount = number_format(($product_price - $discount), 2, '.', '');
                        }

                        $show_discount_label = true;
                        if (isset($cartItem->coupon)) {
                            if ($cartItem->coupon->type == 'cart_base') {
                                $show_discount_label = false;
                            }
                        }
                    ?>
                    <div class="row order-summary-list">
                        <div class="col-5 p-0">
                            <span title="<?php echo e($product->name); ?>"><?php echo e(strlen($product->name) > 20 ? substr(ucwords($product->name), 0, 20)."..." : ucwords($product->name)); ?></span>
                            <?php if($discount > 0 && $show_discount_label): ?>
                                <?php if($product->discount_type === 'amount'): ?>
                                    <span class="discount-badge">₹<?php echo e(number_format($discount , 2, '.', '')); ?> OFF</span>
                                <?php else: ?>
                                    <span class="discount-badge">₹<?php echo e(number_format($discount , 2, '.', '')); ?> OFF</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="col-7 d-flex justify-content-end p-0">
                            <?php if($proceed == 1 && $current_stock > 0): ?>
                            <span class="d-flex aiz-plus-minus mr-0 ml-0 checkout-plus-minus flex-row-reverse">
                                <button
                                    class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                    type="button" data-type="plus"
                                    data-field="quantity[<?php echo e($cartItem->id); ?>]">
                                    <i class="las la-plus"></i>
                                </button>
                                <input type="number" name="quantity[<?php echo e($cartItem->id); ?>]"
                                    class="col border-0 text-center px-0 fs-14 input-number"
                                    placeholder="1" value="<?php echo e($cartItem->quantity); ?>"
                                    min="<?php echo e($product->min_qty); ?>"
                                    max="<?php echo e($current_stock); ?>"
                                    onchange="updateQuantity(<?php echo e($cartItem->id); ?>, this)">
                                <button
                                    class="btn col-auto btn-icon btn-sm btn-light rounded-0"
                                    type="button" data-type="minus"
                                    data-field="quantity[<?php echo e($cartItem->id); ?>]">
                                    <i class="las la-minus"></i>
                                </button>
                            </span>
                            <?php endif; ?>
                            <?php if($current_stock == 0): ?>
                                <span class="text-danger">Out of Stock</span>
                            <?php else: ?>
                                <span class="mx-2">₹<?php echo e(number_format($product_amount, 2, '.', '')); ?></span>
                                <span>(Original: ₹<?php echo e(number_format($product_price , 2, '.', '')); ?>)</span>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <!-- Coupon System -->
                <?php if(get_setting('coupon_system') == 999): ?>
                    <?php if($coupon_discount > 0 && $coupon_code): ?>
                        <div class="coupon-section">
                            <form class="" id="remove-coupon-form" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="proceed" value="<?php echo e($proceed); ?>">
                                <div class="input-group">
                                    <div class="form-control"><?php echo e($coupon_code); ?></div>
                                    <div class="input-group-append">
                                        <button type="button" id="coupon-remove"
                                            class="btn btn-primary"><?php echo e(translate('Change Coupon')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    <?php else: ?>
                        <div class="coupon-section">
                            <form class="" id="apply-coupon-form" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="proceed" value="<?php echo e($proceed); ?>">
                                <div class="input-group">
                                    <input type="text" class="form-control rounded-0" name="code"
                                        onkeydown="return event.key != 'Enter';"
                                        placeholder="<?php echo e(translate('Have coupon code? Apply here')); ?>" required>
                                    <div class="input-group-append">
                                        <button type="button" id="coupon-apply"
                                            class="btn btn-primary rounded-0"><?php echo e(translate('Apply')); ?></button>
                                    </div>
                                </div>
                                <?php if(!auth()->check()): ?>
                                    <small><?php echo e(translate('You must Login as customer to apply coupon')); ?></small>
                                <?php endif; ?>
    
                            </form>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
                <div class="coupon-section">
                    <div class="d-flex justify-content-between py-1">
                        <span>Sub Total</span><span><?php echo e(single_price(number_format($subtotal , 2, '.', ''))); ?></span>
                    </div>
                    <?php
                        $total_dis = $carts->sum('discount');
                    ?>
                    <?php if($total_dis > 0): ?>
                    <div class="d-flex justify-content-between py-1">
                        <span>Total Discount</span><span>-<?php echo e(single_price(number_format($total_dis , 2, '.', ''))); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if($shipping > 0): ?>
                    <div class="d-flex justify-content-between py-1">
                        <span>Shipping Fee</span><span><?php echo e(single_price(number_format($shipping , 2, '.', ''))); ?></span>
                    </div>
                    <?php endif; ?>
                    <div class="d-flex justify-content-between py-1">
                        <span>Tax</span><span><?php echo e(single_price(number_format($tax , 2, '.', ''))); ?></span>
                    </div>
                    
                    <?php
                        $total = $subtotal + $tax + $shipping - $total_dis;
                        $club_point = 0;
                        if (Session::has('club_point')) {
                            $club_point = Session::get('club_point');
                            $total -= $club_point;
                        }
                        if ($coupon_discount > 0) {
                            // $total -= $coupon_discount;
                        }
                    ?>
                    <?php if(Auth::user()->balance): ?>
                    <div class="d-flex justify-content-between bg-light-success p-2 my-2 align-items-center">
                        <span>Wallet Balance (<?php echo e(single_price(Auth::user()->balance)); ?>)</span>
                        <span>-<?php echo e(single_price(number_format($club_point , 2, '.', ''))); ?></span>
                        <input class="form-control w-25 form-control-sm" readonly value="<?php echo e(number_format($club_point , 2, '.', '')); ?>" />
                    </div>
                    <?php endif; ?>
                    <div class="d-flex justify-content-between font-weight-bold py-1">
                        <span style="font-size: 16px;">Total(<span style="font-size:12px;">Inclusive of all Taxes</span>)</span><span style="font-size: 16px;"><?php echo e(single_price(number_format($total , 2, '.', ''))); ?></span>
                    </div>
                </div>
            </div>
            
            <?php if($proceed == 1): ?>
                <!-- Continue to Shipping -->
                <div class="mt-4">
                    <a href="<?php echo e(route('checkout')); ?>" class="btn btn-primary btn-block fs-14 fw-700 rounded-0 px-4">
                        <?php echo e(translate('Proceed to Checkout')); ?> (<?php echo e(sprintf("%02d", count($carts))); ?>)
                    </a>
                </div>
            <?php else: ?>
                <!-- Agree Box -->
                <div class="pt-2 fs-14" style="line-height: 1;">
                    <label class="aiz-checkbox">
                        <input type="checkbox" required id="agree_checkbox" onchange="stepCompletionPaymentInfo()">
                        <span class="aiz-square-check"></span>
                        <span><?php echo e(translate('I agree to the')); ?></span>
                    </label>
                    <a href="<?php echo e(route('terms')); ?>"
                        class="fw-700"><?php echo e(translate('terms and conditions')); ?></a>,
                    <a href="<?php echo e(route('returnpolicy')); ?>"
                        class="fw-700"><?php echo e(translate('return policy')); ?></a> &
                    <a href="<?php echo e(route('privacypolicy')); ?>"
                        class="fw-700"><?php echo e(translate('privacy policy')); ?></a>
                </div>
                <div class="mt-4">
                    <button type="button" id="submitOrderBtn" class="btn btn-primary btn-block fs-14 fw-700 rounded-0 px-4" onclick="submitOrder(this)" disabled>
                        <?php echo e(translate('Pay Now')); ?>

                    </button>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH /home2/akshathealthcare/public_html/resources/views/frontend/partials/cart/cart_summary.blade.php ENDPATH**/ ?>