<div class="aiz-sidebar-wrap">
    <div class="aiz-sidebar left c-scrollbar">
        <div class="aiz-side-nav-logo-wrap">
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="d-block text-left">
                <?php if(get_setting('system_logo_black') != null): ?>
                <img class="mw-100" src="<?php echo e(uploaded_asset(get_setting('system_logo_black'))); ?>" class="brand-icon"
                    alt="<?php echo e(get_setting('site_name')); ?>">
                <?php else: ?>
                <img class="mw-100" src="<?php echo e(static_asset('assets/img/logo.png')); ?>" class="brand-icon"
                    alt="<?php echo e(get_setting('site_name')); ?>">
                <?php endif; ?>
            </a>
        </div>
        <div class="aiz-side-nav-wrap">
            <div class="px-3 mb-3 position-relative">
                <input class="form-control bg-transparent rounded-2 form-control-sm text-white fs-14" type="text"
                    name="" placeholder="<?php echo e(translate('Search in menu')); ?>" id="menu-search" onkeyup="menuSearch()">
                <span class="absolute-top-right pr-3 mr-3" style="margin-top: 10px;">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                        <path id="search_FILL0_wght200_GRAD0_opsz20"
                            d="M176.921-769.231l6.255-6.255a5.99,5.99,0,0,0,1.733.949,5.687,5.687,0,0,0,1.885.329,5.317,5.317,0,0,0,3.9-1.608,5.31,5.31,0,0,0,1.609-3.9,5.322,5.322,0,0,0-1.608-3.9,5.306,5.306,0,0,0-3.9-1.611,5.321,5.321,0,0,0-3.9,1.609,5.312,5.312,0,0,0-1.611,3.9,5.554,5.554,0,0,0,.35,1.946,6.043,6.043,0,0,0,.929,1.672l-6.255,6.255Zm9.874-5.82a4.51,4.51,0,0,1-3.317-1.352,4.51,4.51,0,0,1-1.352-3.317,4.51,4.51,0,0,1,1.352-3.317,4.51,4.51,0,0,1,3.317-1.352,4.51,4.51,0,0,1,3.317,1.352,4.51,4.51,0,0,1,1.352,3.317,4.51,4.51,0,0,1-1.352,3.317A4.51,4.51,0,0,1,186.8-775.051Z"
                            transform="translate(-176.307 785.231)" fill="#4e5767" />
                    </svg>
                </span>
            </div>
            <ul class="aiz-side-nav-list" id="search-menu">
            </ul>
            <ul class="aiz-side-nav-list" id="main-menu" data-toggle="aiz-side-menu">

                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin_dashboard')): ?>
                <li class="aiz-side-nav-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="_3d6902ec768df53cd9e274ca8a57e401"
                                    data-name="3d6902ec768df53cd9e274ca8a57e401"
                                    d="M18,12.286a1.715,1.715,0,0,0-1.714-1.714h-4a1.715,1.715,0,0,0-1.714,1.714v4A1.715,1.715,0,0,0,12.286,18h4A1.715,1.715,0,0,0,18,16.286Zm-8.571,0a1.715,1.715,0,0,0-1.714-1.714h-4A1.715,1.715,0,0,0,2,12.286v4A1.715,1.715,0,0,0,3.714,18h4a1.715,1.715,0,0,0,1.714-1.714Zm7.429,0v4a.57.57,0,0,1-.571.571h-4a.57.57,0,0,1-.571-.571v-4a.57.57,0,0,1,.571-.571h4a.57.57,0,0,1,.571.571Zm-8.571,0v4a.57.57,0,0,1-.571.571h-4a.57.57,0,0,1-.571-.571v-4a.57.57,0,0,1,.571-.571h4a.57.57,0,0,1,.571.571ZM9.429,3.714A1.715,1.715,0,0,0,7.714,2h-4A1.715,1.715,0,0,0,2,3.714v4A1.715,1.715,0,0,0,3.714,9.429h4A1.715,1.715,0,0,0,9.429,7.714Zm8.571,0A1.715,1.715,0,0,0,16.286,2h-4a1.715,1.715,0,0,0-1.714,1.714v4a1.715,1.715,0,0,0,1.714,1.714h4A1.715,1.715,0,0,0,18,7.714Zm-9.714,0v4a.57.57,0,0,1-.571.571h-4a.57.57,0,0,1-.571-.571v-4a.57.57,0,0,1,.571-.571h4a.57.57,0,0,1,.571.571Zm8.571,0v4a.57.57,0,0,1-.571.571h-4a.57.57,0,0,1-.571-.571v-4a.57.57,0,0,1,.571-.571h4a.57.57,0,0,1,.571.571Z"
                                    transform="translate(-2 -2)" fill="#575b6a" fill-rule="evenodd" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Dashboard')); ?></span>
                    </a>
                </li>
                <?php endif; ?>

                <!-- POS Addon-->
                <?php if(addon_is_activated('pos_system') && (auth()->user()->can('pos_manager') || auth()->user()->can('pos_configuration'))): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="13.79" height="16" viewBox="0 0 13.79 16">
                                <g id="_371925cdd3f531725a9fa8f3ebf8fe9e" data-name="371925cdd3f531725a9fa8f3ebf8fe9e"
                                    transform="translate(-2.26 0)">
                                    <path id="Path_40673" data-name="Path 40673"
                                        d="M10.69,7H3.26a1.025,1.025,0,0,0-1,1V18.45a1.03,1.03,0,0,0,1,1.05h7.43a1.03,1.03,0,0,0,1.03-1.03V8A1.025,1.025,0,0,0,10.69,7ZM4.94,17.86H3.995v-.95H4.94Zm0-2.355H3.995v-.95H4.94Zm0-2.355H3.995V12.2H4.94Zm2.5,4.71H6.5v-.95h.955Zm0-2.355H6.5v-.95h.955Zm0-2.355H6.5V12.2h.955Zm2.5,4.71H8.99v-.95h.95Zm0-2.355H8.99v-.95h.95Zm0-2.355H8.99V12.2h.95Zm.325-3a.17.17,0,0,1-.165.17H3.835a.17.17,0,0,1-.165-.17V8.795a.165.165,0,0,1,.165-.165H10.13a.165.165,0,0,1,.165.165Zm5.09-1.45H15.13v9.09h.25a.67.67,0,0,0,.67-.67V9.375a.67.67,0,0,0-.695-.675Z"
                                        transform="translate(0 -3.5)" fill="#4e5767" />
                                    <rect id="Rectangle_20842" data-name="Rectangle 20842" width="1.465" height="9.095"
                                        transform="translate(12.185 5.2)" fill="#4e5767" />
                                    <rect id="Rectangle_20843" data-name="Rectangle 20843" width="0.63" height="9.095"
                                        transform="translate(14.06 5.2)" fill="#4e5767" />
                                    <path id="Path_40674" data-name="Path 40674"
                                        d="M13.895.895a.89.89,0,0,0-.26-.635A.91.91,0,0,0,13,0a.895.895,0,0,0-.91.895v.53h1.79Zm-2.2,0a.76.76,0,0,1,0-.145.68.68,0,0,1,0-.1h.01A.5.5,0,0,1,11.755.5.43.43,0,0,1,11.79.4a1.2,1.2,0,0,1,.145-.26.5.5,0,0,1,.04-.055L12.045,0H7.995A.815.815,0,0,0,7.18.81V3.03h4.5Z"
                                        transform="translate(-2.46)" fill="#4e5767" />
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('POS System')); ?></span>
                        <?php if(env("DEMO_MODE") == "On"): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001" viewBox="0 0 16 14.001"
                            class="mx-2">
                            <path id="Union_49" data-name="Union 49"
                                d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                transform="translate(19337 -3329)" fill="#f51350" />
                        </svg>
                        <?php endif; ?>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pos_manager')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('poin-of-sales.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['poin-of-sales.index', 'poin-of-sales.create'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('POS Manager')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pos_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('poin-of-sales.activation')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('POS Configuration')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Product -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['add_new_product', 'show_all_products','show_in_house_products','show_seller_products','show_digital_products','product_bulk_import',
                        'product_bulk_export','view_product_categories','view_all_brands', 'brand_bulk_upload','view_product_attributes','view_colors','view_product_warranties','view_product_reviews'])): ?>
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <div class="aiz-side-nav-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="13.714" viewBox="0 0 16 13.714">
                                    <g id="Layer_2" data-name="Layer 2" transform="translate(-2 -4)">
                                        <path id="Path_40719" data-name="Path 40719"
                                            d="M17.429,4H2.571A.571.571,0,0,0,2,4.571V8a.571.571,0,0,0,.571.571h.571v8.571a.571.571,0,0,0,.571.571H16.286a.571.571,0,0,0,.571-.571V8.571h.571A.571.571,0,0,0,18,8V4.571A.571.571,0,0,0,17.429,4ZM15.714,16.571H4.286v-8H15.714Zm1.143-9.143H3.143V5.143H16.857Z"
                                            fill="#575b6a" />
                                        <path id="Path_40720" data-name="Path 40720"
                                            d="M12.571,15.143H16A.571.571,0,0,0,16,14H12.571a.571.571,0,0,0,0,1.143Z"
                                            transform="translate(-4.286 -4.286)" fill="#575b6a" />
                                    </g>
                                </svg>
                            </div>
                            <span class="aiz-side-nav-text"><?php echo e(translate('Products')); ?></span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <!--Submenu-->
                        <ul class="aiz-side-nav-list level-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_new_product')): ?>
                            <li class="aiz-side-nav-item">
                                <a class="aiz-side-nav-link" href="<?php echo e(route('products.create')); ?>">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Add New product')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show_all_products')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('products.all')); ?>" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('All Products')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show_in_house_products')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('products.admin')); ?>"
                                    class="aiz-side-nav-link <?php echo e(areActiveRoutes(['products.admin', 'products.admin.edit'])); ?>">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('In House Products')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            
                            <?php if(get_setting('vendor_system_activation') == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show_seller_products')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="javascript:void(0);" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Seller Product')); ?></span>
                                    <span class="aiz-side-nav-arrow"></span>
                                </a>
                                <ul class="aiz-side-nav-list level-3">
                                    <li class="aiz-side-nav-item">
                                        <a href="<?php echo e(route('products.seller','physical')); ?>" class="aiz-side-nav-link">
                                            <span class="aiz-side-nav-text"><?php echo e(translate('Physical Products')); ?></span>
                                        </a>
                                    </li>
                                    
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_bulk_import')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('product_bulk_upload.index')); ?>" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Bulk Import')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_bulk_export')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('product_bulk_export.index')); ?>" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Bulk Export')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_categories')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('categories.index')); ?>"
                                    class="aiz-side-nav-link <?php echo e(areActiveRoutes(['categories.index', 'categories.create', 'categories.edit'])); ?>">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Category')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('set_category_wise_discount')): ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('categories_wise_product_discount')); ?>" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Category Based Discount')); ?></span>
                                </a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_brands', 'brand_bulk_upload'])): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="javascript:void(0);" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Company')); ?></span>
                                        <span class="aiz-side-nav-arrow"></span>
                                    </a>
                                    <ul class="aiz-side-nav-list level-3">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_brands')): ?>
                                        <li class="aiz-side-nav-item">
                                            <a href="<?php echo e(route('brands.index')); ?>" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['brands.index', 'brands.create', 'brands.edit'])); ?>">
                                                <span class="aiz-side-nav-text"><?php echo e(translate('All Company')); ?></span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brand_bulk_upload')): ?>
                                        <li class="aiz-side-nav-item">
                                            <a href="<?php echo e(route('brand_bulk_upload.index')); ?>" class="aiz-side-nav-link">
                                                <span class="aiz-side-nav-text"><?php echo e(translate('Company Bulk Import')); ?></span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                    </ul>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_attributes')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('attributes.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['attributes.index','attributes.create','attributes.edit','attributes.show','edit-attribute-value'.''])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Attribute')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_colors')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('colors')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['colors','colors.edit'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Colors')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_size_charts', 'view_measurement_points'])): ?>
                            <li class="aiz-side-nav-item">
                                <a href="javascript:void(0);" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Size Guide')); ?></span>
                                    <span class="aiz-side-nav-arrow"></span>
                                </a>
                                <ul class="aiz-side-nav-list level-3">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_size_charts')): ?>
                                        <li class="aiz-side-nav-item">
                                            <a href="<?php echo e(route('size-charts.index')); ?>" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['size-charts.index', 'size-charts.create', 'size-charts.edit'])); ?>">
                                                <span class="aiz-side-nav-text"><?php echo e(translate('Size Chart')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_measurement_points')): ?>
                                        <li class="aiz-side-nav-item">
                                            <a href="<?php echo e(route('measurement-points.index')); ?>" class="aiz-side-nav-link">
                                                <span class="aiz-side-nav-text"><?php echo e(translate('Measurement Points')); ?></span>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_warranties')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('warranties.index')); ?>" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['warranties.edit'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Warranty')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_reviews')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('reviews.index')); ?>" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['detail-reviews', 'custom-review.edit'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Product Reviews')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                
                

                <!-- Note  -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_notes', 'add_note'])): ?>
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <div class="aiz-side-nav-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16.001" viewBox="0 0 16 16.001">
                                    <path id="Union_64" data-name="Union 64" d="M.333,16A.315.315,0,0,1,0,15.668V.335A.315.315,0,0,1,.333,0h9.31a.285.285,0,0,1,.123.014A.318.318,0,0,1,9.9.1l2.667,2.667.009.01a.293.293,0,0,1,.079.132.274.274,0,0,1,.012.112V5.835l1.267-1.267a.322.322,0,0,1,.466,0l1.5,1.5a.322.322,0,0,1,0,.466L12.667,9.768v5.9a.315.315,0,0,1-.333.333Zm.334-.666H12v-4.9L9.133,13.3a.3.3,0,0,1-.233.1H8.882L6.4,14.468a.2.2,0,0,1-.133.033.332.332,0,0,1-.3-.466l.589-1.368H2.667a.333.333,0,0,1,0-.667H6.843l.258-.6a.321.321,0,0,1,.176-.177L8.5,10H2.667a.333.333,0,0,1,0-.667h6.5L12,6.5V3.335H9.667A.315.315,0,0,1,9.333,3V.668H.667Zm6.233-1.8,1.4-.6-.8-.8-.1.239a.323.323,0,0,1-.074.172Zm2-.967,6.3-6.3-.283-.283-6.3,6.3ZM7.867,11.534l.284.284,6.3-6.3-.283-.283L12.624,6.777a.291.291,0,0,1-.115.115L9.558,9.844a.291.291,0,0,1-.115.115ZM10,2.668h1.533L10.767,1.9,10,1.135ZM2.667,7.335a.333.333,0,0,1,0-.667H10a.333.333,0,1,1,0,.667Zm0-2.668a.333.333,0,1,1,0-.666H10a.333.333,0,1,1,0,.666Z" fill="#575b6a"/>
                                </svg>
                            </div>
                            <span class="aiz-side-nav-text"><?php echo e(translate('Notes')); ?></span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <!--Submenu-->
                        <ul class="aiz-side-nav-list level-2">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_note')): ?>
                                <li class="aiz-side-nav-item">
                                    <a class="aiz-side-nav-link" href="<?php echo e(route('note.create')); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Add New Note')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_notes')): ?>
                                <li class="aiz-side-nav-item">
                                    <a class="aiz-side-nav-link" href="<?php echo e(route('note.index')); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Note List')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                <?php endif; ?>

                <!-- Auction Product -->
                

                <!-- Wholesale Product -->
                

                <!-- Sale -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_orders', 'view_inhouse_orders','view_seller_orders','view_pickup_point_orders'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="15.997" height="16" viewBox="0 0 15.997 16">
                                <g id="Layer_2" data-name="Layer 2" transform="translate(-2 -1.994)">
                                    <path id="Path_40726" data-name="Path 40726"
                                        d="M4.857,12.571H3.714A1.714,1.714,0,0,0,2,14.285V20.57a1.714,1.714,0,0,0,1.714,1.714H4.857A1.714,1.714,0,0,0,6.571,20.57V14.285a1.714,1.714,0,0,0-1.714-1.714Zm.571,8a.571.571,0,0,1-.571.571H3.714a.571.571,0,0,1-.571-.571V14.285a.571.571,0,0,1,.571-.571H4.857a.571.571,0,0,1,.571.571Zm5.142-6.284H9.427A1.714,1.714,0,0,0,7.713,16V20.57a1.714,1.714,0,0,0,1.714,1.714H10.57a1.714,1.714,0,0,0,1.714-1.714V16A1.714,1.714,0,0,0,10.57,14.285Zm.571,6.284a.571.571,0,0,1-.571.571H9.427a.571.571,0,0,1-.571-.571V16a.571.571,0,0,1,.571-.571H10.57a.571.571,0,0,1,.571.571ZM16.283,12H15.14a1.714,1.714,0,0,0-1.714,1.714V20.57a1.714,1.714,0,0,0,1.714,1.714h1.143A1.714,1.714,0,0,0,18,20.57V13.714A1.714,1.714,0,0,0,16.283,12Zm.571,8.57a.571.571,0,0,1-.571.571H15.14a.571.571,0,0,1-.571-.571V13.714a.571.571,0,0,1,.571-.571h1.143a.571.571,0,0,1,.571.571Z"
                                        transform="translate(0 -4.289)" fill="#575b6a" />
                                    <path id="Path_40727" data-name="Path 40727"
                                        d="M17.947,2.548a.571.571,0,0,0-.366-.24l-1.588-.3a.571.571,0,1,0-.213,1.122l.093.018L11.233,5.932l-5.45-2.18a.572.572,0,1,0-.424,1.062L11.072,7.1a.571.571,0,0,0,.506-.041L16.68,4l-.067.354a.571.571,0,0,0,.457.668.579.579,0,0,0,.107.01.571.571,0,0,0,.56-.465l.3-1.588A.568.568,0,0,0,17.947,2.548Z"
                                        transform="translate(-1.286)" fill="#575b6a" />
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Sales')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <!--Submenu-->
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('all_orders.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['all_orders.index', 'all_orders.show'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('All Orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_inhouse_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('inhouse_orders.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['inhouse_orders.index', 'inhouse_orders.show'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Inhouse orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(get_setting('vendor_system_activation') == 1): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_seller_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('seller_orders.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['seller_orders.index', 'seller_orders.show'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_pickup_point_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('pick_up_point.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['pick_up_point.index','pick_up_point.order_show'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Pick-up Point Orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_unpaid_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('unpaid_orders.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['unpaid_orders.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Unpaid Orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Deliver Boy Addon-->
                

                <!-- Refund addon -->
                <?php if(addon_is_activated('refund_request')): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_refund_requests','view_approved_refund_requests','view_rejected_refund_requests','refund_request_configuration'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="_4436b8ef9250481406399210799cb7f1"
                                    data-name="4436b8ef9250481406399210799cb7f1"
                                    d="M19.25,11.25a8.031,8.031,0,0,1-15.995,1,.688.688,0,0,1,1.365-.169A6.643,6.643,0,1,0,7.112,6.039h.866a.686.686,0,1,1,0,1.371H5.384A.687.687,0,0,1,4.7,6.724V4.138a.688.688,0,0,1,1.376,0v.987A8.024,8.024,0,0,1,19.25,11.25ZM11.278,6.907a.687.687,0,0,0-.688.686v.253a2.053,2.053,0,0,0-1.824,2.247,2.146,2.146,0,0,0,2.175,1.842h.8a.686.686,0,1,1,0,1.371h-1.6a.686.686,0,1,0,0,1.371h.458v.229a.688.688,0,0,0,1.376,0v-.26a2.113,2.113,0,0,0,1.824-1.811,2.062,2.062,0,0,0-2.053-2.272h-.917a.686.686,0,1,1,0-1.371h1.609a.686.686,0,1,0,0-1.371h-.462V7.593A.687.687,0,0,0,11.278,6.907Z"
                                    transform="translate(-3.25 -3.25)" fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Refunds')); ?></span>
                        <?php if(env("DEMO_MODE") == "On"): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001" viewBox="0 0 16 14.001"
                            class="mx-2">
                            <path id="Union_49" data-name="Union 49"
                                d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                transform="translate(19337 -3329)" fill="#f51350" />
                        </svg>
                        <?php endif; ?>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_refund_requests')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('refund_requests_all')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['refund_requests_all', 'reason_show'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Refund Requests')); ?></span>
                            </a>
                            <ul class="aiz-side-nav-list level-2">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_refund_requests')): ?>
                                    <li class="aiz-side-nav-item">
                                        <a href="<?php echo e(route('refund_requests_all')); ?>" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['refund_requests_all', 'admin.reason_show'])); ?>">
                                            <span class="aiz-side-nav-text"><?php echo e(translate('Refund Requests')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_approved_refund_requests')): ?>
                                    <li class="aiz-side-nav-item">
                                        <a href="<?php echo e(route('paid_refund')); ?>" class="aiz-side-nav-link">
                                            <span class="aiz-side-nav-text"><?php echo e(translate('Approved Refunds')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_rejected_refund_requests')): ?>
                                    <li class="aiz-side-nav-item">
                                        <a href="<?php echo e(route('rejected_refund')); ?>" class="aiz-side-nav-link">
                                            <span class="aiz-side-nav-text"><?php echo e(translate('Rejected Refunds')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('refund_request_configuration')): ?>
                                    <li class="aiz-side-nav-item">
                                        <a href="<?php echo e(route('refund_time_config')); ?>" class="aiz-side-nav-link">
                                            <span class="aiz-side-nav-text"><?php echo e(translate('Refund Configuration')); ?></span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_approved_refund_requests')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('paid_refund')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Approved Refunds')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_rejected_refund_requests')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('rejected_refund')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Rejected Refunds')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('refund_request_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('refund_time_config')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Refund Configuration')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php endif; ?>

                <!-- Customers -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_customers','view_classified_products','view_classified_packages'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="Path_40769" data-name="Path 40769"
                                    d="M8,10.667A2.667,2.667,0,1,1,10.667,8,2.667,2.667,0,0,1,8,10.667Zm0-4A1.333,1.333,0,1,0,9.333,8,1.333,1.333,0,0,0,8,6.667Zm4,8.667a4,4,0,1,0-8,0,.667.667,0,0,0,1.333,0,2.667,2.667,0,1,1,5.333,0,.667.667,0,0,0,1.333,0Zm0-10a2.667,2.667,0,1,1,2.667-2.667A2.667,2.667,0,0,1,12,5.333Zm0-4a1.333,1.333,0,1,0,1.333,1.333A1.333,1.333,0,0,0,12,1.333ZM16,10a4,4,0,0,0-4-4,.667.667,0,0,0,0,1.333A2.667,2.667,0,0,1,14.667,10,.667.667,0,1,0,16,10ZM4,5.333A2.667,2.667,0,1,1,6.667,2.667,2.667,2.667,0,0,1,4,5.333Zm0-4A1.333,1.333,0,1,0,5.333,2.667,1.333,1.333,0,0,0,4,1.333ZM1.333,10A2.667,2.667,0,0,1,4,7.333.667.667,0,0,0,4,6a4,4,0,0,0-4,4,.667.667,0,0,0,1.333,0Z"
                                    fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Customers')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_customers')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('customers.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['customers.create'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Customer list')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(get_setting('classified_product') == 1): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_classified_products')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('classified_products')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Classified Products')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_classified_packages')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('customer_packages.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['customer_packages.index', 'customer_packages.create', 'customer_packages.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Classified Packages')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Wholesellers -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_customers','view_classified_products','view_classified_packages'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="Path_40769" data-name="Path 40769"
                                    d="M8,10.667A2.667,2.667,0,1,1,10.667,8,2.667,2.667,0,0,1,8,10.667Zm0-4A1.333,1.333,0,1,0,9.333,8,1.333,1.333,0,0,0,8,6.667Zm4,8.667a4,4,0,1,0-8,0,.667.667,0,0,0,1.333,0,2.667,2.667,0,1,1,5.333,0,.667.667,0,0,0,1.333,0Zm0-10a2.667,2.667,0,1,1,2.667-2.667A2.667,2.667,0,0,1,12,5.333Zm0-4a1.333,1.333,0,1,0,1.333,1.333A1.333,1.333,0,0,0,12,1.333ZM16,10a4,4,0,0,0-4-4,.667.667,0,0,0,0,1.333A2.667,2.667,0,0,1,14.667,10,.667.667,0,1,0,16,10ZM4,5.333A2.667,2.667,0,1,1,6.667,2.667,2.667,2.667,0,0,1,4,5.333Zm0-4A1.333,1.333,0,1,0,5.333,2.667,1.333,1.333,0,0,0,4,1.333ZM1.333,10A2.667,2.667,0,0,1,4,7.333.667.667,0,0,0,4,6a4,4,0,0,0-4,4,.667.667,0,0,0,1.333,0Z"
                                    fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Wholesellers')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_customers')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('wholesellers.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['wholesellers.create'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Wholesellers list')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(get_setting('classified_product') == 1): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_classified_products')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('classified_products')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Classified Products')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_classified_packages')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('customer_packages.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['customer_packages.index', 'customer_packages.create', 'customer_packages.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Classified Packages')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Sellers -->
                <?php if(get_setting('vendor_system_activation') == 1): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_seller','seller_payment_history','view_seller_payout_requests','seller_commission_configuration','view_all_seller_packages','seller_verification_form_configuration'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="ef567a7fa3ca8f4541f8ab7b62352aa6"
                                    d="M19,9.625a.638.638,0,0,0-.079-.307l-2.779-5A.614.614,0,0,0,15.606,4H6.394a.614.614,0,0,0-.536.318l-2.779,5A.638.638,0,0,0,3,9.625a2.5,2.5,0,0,0,1.231,2.153V18.75A1.24,1.24,0,0,0,5.462,20H9.08a1.24,1.24,0,0,0,1.231-1.25V16.058a.759.759,0,0,1,.615-.773.684.684,0,0,1,.534.176.706.706,0,0,1,.229.521V18.75A1.24,1.24,0,0,0,12.92,20h3.618a1.24,1.24,0,0,0,1.231-1.25V11.777A2.5,2.5,0,0,0,19,9.625Zm-1.239.149a1.23,1.23,0,0,1-2.453-.149.578.578,0,0,0-.017-.086.548.548,0,0,0-.006-.084L14.114,5.25h1.132ZM9.164,5.25h1.22V9.625a1.23,1.23,0,0,1-2.455.063Zm2.451,0h1.22l1.235,4.437a1.23,1.23,0,0,1-2.455-.062Zm-4.862,0H7.886l-1.169,4.2a.548.548,0,0,0-.006.084.578.578,0,0,0-.018.086,1.23,1.23,0,0,1-2.453.149Zm9.785,13.5H12.92V15.981a1.964,1.964,0,0,0-.635-1.446,1.9,1.9,0,0,0-1.482-.491A2,2,0,0,0,9.08,16.061V18.75H5.462V12.125a2.439,2.439,0,0,0,1.846-.848A2.419,2.419,0,0,0,11,11.261a2.419,2.419,0,0,0,3.692.016,2.439,2.439,0,0,0,1.846.848Z"
                                    transform="translate(-3 -4)" fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Sellers')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_seller')): ?>
                        <li class="aiz-side-nav-item">
                            <?php
                            $sellers = \App\Models\Shop::where('verification_status', 0)->where('verification_info',
                            '!=', null)->count();
                            ?>
                            <a href="<?php echo e(route('sellers.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['sellers.index', 'sellers.create', 'sellers.edit', 'sellers.payment_history','sellers.approved','sellers.profile_modal','sellers.show_verification_request'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('All Seller')); ?></span>
                                <?php if($sellers > 0): ?><span class="badge badge-info"><?php echo e($sellers); ?></span> <?php endif; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_seller_rating_and_followers')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('sellers.rating_followers')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Rating & Followers')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seller_payment_history')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('sellers.payment_histories')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Payouts')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_seller_payout_requests')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('withdraw_requests_all')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Payout Requests')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seller_commission_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('business_settings.vendor_commission')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Commission')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(addon_is_activated('seller_subscription')): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_seller_packages')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('seller_packages.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['seller_packages.index', 'seller_packages.create', 'seller_packages.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Packages')); ?></span>
                                <?php if(env("DEMO_MODE") == "On"): ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001"
                                    viewBox="0 0 16 14.001" class="mx-2">
                                    <path id="Union_49" data-name="Union 49"
                                        d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                        transform="translate(19337 -3329)" fill="#f51350" />
                                </svg>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seller_verification_form_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('seller_verification_form.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Verification Form')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php endif; ?>

                
                <li class="aiz-side-nav-item">
                    <a href="<?php echo e(route('uploaded-files.index')); ?>"
                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['uploaded-files.create'])); ?>">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="layer1" transform="translate(-0.53 -0.53)">
                                    <path id="path3159"
                                        d="M3.386.53A2.862,2.862,0,0,0,.53,3.386V13.67a2.865,2.865,0,0,0,2.856,2.86H13.67a2.869,2.869,0,0,0,2.86-2.86V3.386A2.865,2.865,0,0,0,13.67.53Zm0,1.143H13.67a1.7,1.7,0,0,1,1.718,1.713V13.67a1.7,1.7,0,0,1-1.718,1.718H3.386A1.7,1.7,0,0,1,1.673,13.67V3.386A1.7,1.7,0,0,1,3.386,1.673ZM8.12,3.557,5.34,6.37a.572.572,0,0,0,0,.809.564.564,0,0,0,.81,0l1.8-1.824V10.8a.571.571,0,0,0,1.143,0V5.347l1.8,1.829a.571.571,0,0,0,.81-.806L8.935,3.557a.511.511,0,0,0-.815,0Zm-4.156,8.97a.571.571,0,0,0,0,1.143h9.128a.571.571,0,0,0,0-1.143Z"
                                        fill="#575b6a" />
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Uploaded Files')); ?></span>
                    </a>
                </li>

                <!-- Reports -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['earning_report',
                'in_house_product_sale_report','seller_products_sale_report','products_stock_report','product_wishlist_report','user_search_report','commission_history_report','wallet_transaction_report'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg id="stats_3916778" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                viewBox="0 0 16 16">
                                <path id="Path_40739" data-name="Path 40739"
                                    d="M16,16H2a2,2,0,0,1-2-2V0H1.333V14A.667.667,0,0,0,2,14.667H16Z" fill="#575b6a" />
                                <rect id="Rectangle_21340" data-name="Rectangle 21340" width="1.333" height="6"
                                    transform="translate(9.333 7.333)" fill="#575b6a" />
                                <rect id="Rectangle_21341" data-name="Rectangle 21341" width="1.333" height="6"
                                    transform="translate(4 7.333)" fill="#575b6a" />
                                <rect id="Rectangle_21342" data-name="Rectangle 21342" width="1.333" height="9.333"
                                    transform="translate(12 4)" fill="#575b6a" />
                                <rect id="Rectangle_21343" data-name="Rectangle 21343" width="1.333" height="9.333"
                                    transform="translate(6.667 4)" fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Reports')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('earning_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('earning_payout_report.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Earning Report')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('in_house_product_sale_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('in_house_sale_report.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['in_house_sale_report.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('In House Product Sale')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seller_products_sale_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('seller_sale_report.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['seller_sale_report.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Seller Products Sale')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products_stock_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('stock_report.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['stock_report.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Products Stock')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_wishlist_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('wish_report.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['wish_report.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Products wishlist')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_search_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('user_search_report.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['user_search_report.index'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('User Searches')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('commission_history_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('commission-log.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Commission History')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('wallet_transaction_report')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('wallet-history.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Wallet Recharge History')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!--Blog System-->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_blogs','view_blog_categories'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="Path_40771" data-name="Path 40771"
                                    d="M9.688,16H3.75A3.754,3.754,0,0,1,0,12.25V3.75A3.754,3.754,0,0,1,3.75,0h8.5A3.754,3.754,0,0,1,16,3.75V9.734a.625.625,0,0,1-1.25,0V3.75a2.5,2.5,0,0,0-2.5-2.5H3.75a2.5,2.5,0,0,0-2.5,2.5v8.5a2.5,2.5,0,0,0,2.5,2.5H9.688a.625.625,0,0,1,0,1.25ZM12.875,3.938a.625.625,0,0,0-.625-.625H6.531a.625.625,0,0,0,0,1.25H12.25A.625.625,0,0,0,12.875,3.938Zm0,2.5a.625.625,0,0,0-.625-.625H3.75a.625.625,0,0,0,0,1.25h8.5A.625.625,0,0,0,12.875,6.438Zm-6.25,2.5A.625.625,0,0,0,6,8.313H3.75a.625.625,0,0,0,0,1.25H6A.625.625,0,0,0,6.625,8.938Zm-3.5-5.062a.781.781,0,1,0,.781-.781A.781.781,0,0,0,3.125,3.875ZM15.332,15.332a2.284,2.284,0,0,0,0-3.226L13.141,9.915a4.506,4.506,0,0,0-2.31-1.236L9.06,8.325a.625.625,0,0,0-.735.735l.354,1.771a4.506,4.506,0,0,0,1.236,2.31l2.191,2.191a2.281,2.281,0,0,0,3.226,0ZM10.586,9.9a3.259,3.259,0,0,1,1.671.894l2.191,2.191a1.031,1.031,0,1,1-1.458,1.458L10.8,12.257A3.26,3.26,0,0,1,9.9,10.586l-.17-.852Z"
                                    fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Blog System')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_blogs')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('blog.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['blog.create', 'blog.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('All Posts')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_blog_categories')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('blog-category.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['blog-category.create', 'blog-category.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Categories')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- marketing -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_flash_deals',
                'view_all_dynamic_popups',
                'view_all_custom_alerts',
                'manage_email_templates',
                'send_newsletter',
                'notification_settings',
                'view_all_notification_types',
                'send_custom_notification',
                'view_custom_notification_history',
                'send_bulk_sms',
                'view_all_subscribers',
                'view_all_coupons'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="_8dbc7a38f7bdee3f0be2c44d010760a2" data-name="8dbc7a38f7bdee3f0be2c44d010760a2"
                                    transform="translate(0 -4.027)">
                                    <path id="Path_40740" data-name="Path 40740"
                                        d="M38.286,16.393a.555.555,0,0,1-.344-.119L34.032,13.2a.557.557,0,0,1-.213-.438v-5.1a.556.556,0,0,1,.212-.438l3.91-3.074a.557.557,0,0,1,.9.438V15.836a.556.556,0,0,1-.556.557Zm-3.354-3.9,2.8,2.2V5.73l-2.8,2.2Z"
                                        transform="translate(-25.364 0)" fill="#575b6a" />
                                    <path id="Path_40741" data-name="Path 40741"
                                        d="M9.011,22.556H3.093a3.1,3.1,0,0,1,0-6.192H9.011a.557.557,0,0,1,.557.557V22A.557.557,0,0,1,9.011,22.556ZM3.093,17.478a1.982,1.982,0,0,0,0,3.964H8.455V17.478Z"
                                        transform="translate(0 -9.25)" fill="#575b6a" />
                                    <path id="Path_40742" data-name="Path 40742"
                                        d="M10.2,31.9a1.895,1.895,0,0,1-1.847-1.5l-.974-5.455a.557.557,0,1,1,1.089-.229l.975,5.455a.777.777,0,1,0,1.521-.32l-.824-4.74a.557.557,0,1,1,1.089-.229l.824,4.74A1.894,1.894,0,0,1,10.2,31.9Zm8.487-7.6h-.862a.557.557,0,0,1,0-1.114h.862a1.105,1.105,0,0,0,1.1-1.105,1.106,1.106,0,0,0-1.1-1.105h-.862a.557.557,0,0,1,0-1.114h.862a2.22,2.22,0,0,1,1.566,3.79A2.2,2.2,0,0,1,18.683,24.3Z"
                                        transform="translate(-4.9 -11.875)" fill="#575b6a" />
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Marketing')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_flash_deals')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('flash_deals.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['flash_deals.index', 'flash_deals.create', 'flash_deals.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Flash deals')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_dynamic_popups')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('dynamic-popups.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['dynamic-popups.index', 'dynamic-popups.create', 'dynamic-popups.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Dynamic Pop-up')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_custom_alerts')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('custom-alerts.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['custom-alerts.index', 'custom-alerts.create', 'custom-alerts.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Custom Alert')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_email_templates')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="javascript:void(0);" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Email Templates')); ?></span>
                                <span class="aiz-side-nav-arrow"></span>
                            </a>
                            <ul class="aiz-side-nav-list level-3">
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('email-templates.index', 'admin')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Admin Templates')); ?></span>
                                    </a>
                                </li>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('email-templates.index', 'seller')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Seller Templates')); ?></span>
                                    </a>
                                </li>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('email-templates.index', 'customer')); ?>"
                                        class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Customer Templates')); ?></span>
                                    </a>
                                </li>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('email-templates.index', 'all')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Common Templates')); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <?php endif; ?>
                        
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('send_newsletter')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('newsletters.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Newsletters')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['notification_settings','view_all_notification_types','send_custom_notification', 'view_custom_notification_history'])): ?>
                        <li class="aiz-side-nav-item">
                            <a href="javascript:void(0);" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Notification')); ?></span>
                                <span class="aiz-side-nav-arrow"></span>
                            </a>
                            <ul class="aiz-side-nav-list level-3">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('notification_settings')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('notification.settings')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Settings')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_notification_types')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('notification-type.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['notification-type.edit'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Notification Types')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('send_custom_notification')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('custom_notification')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Custom Notification')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_custom_notification_history')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('custom_notification.history')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Custom Notification History')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>
                        <?php if(addon_is_activated('otp_system') && auth()->user()->can('send_bulk_sms')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('sms.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Bulk SMS')); ?></span>
                                <?php if(env("DEMO_MODE") == "On"): ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001"
                                    viewBox="0 0 16 14.001" class="mx-2">
                                    <path id="Union_49" data-name="Union 49"
                                        d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                        transform="translate(19337 -3329)" fill="#f51350" />
                                </svg>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(addon_is_activated('otp_system') && auth()->user()->can('send_bulk_sms')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('feedback.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Feedback SMS')); ?></span>
                                <?php if(env("DEMO_MODE") == "On"): ?>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001"
                                    viewBox="0 0 16 14.001" class="mx-2">
                                    <path id="Union_49" data-name="Union 49"
                                        d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                        transform="translate(19337 -3329)" fill="#f51350" />
                                </svg>
                                <?php endif; ?>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_subscribers')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('subscribers.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Subscribers')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(get_setting('coupon_system') == 1 && auth()->user()->can('view_all_coupons') ): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('coupon.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['coupon.index','coupon.create','coupon.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Coupon')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Support -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_support_tickets','view_all_product_conversations','view_all_product_queries'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_28286" data-name="Group 28286" transform="translate(0)">
                                    <path id="Path_40743" data-name="Path 40743"
                                        d="M16,9.125a3.122,3.122,0,0,0-1.255-2.5,6.9,6.9,0,0,0-1.94-4.6,6.725,6.725,0,0,0-9.61,0,6.9,6.9,0,0,0-1.94,4.6,3.124,3.124,0,0,0,1.87,5.627h1.25A.625.625,0,0,0,5,11.625v-5A.625.625,0,0,0,4.375,6H3.125a3.129,3.129,0,0,0-.569.052,5.487,5.487,0,0,1,10.887,0A3.129,3.129,0,0,0,12.875,6h-1.25A.625.625,0,0,0,11,6.625v5a.625.625,0,0,0,.625.625h.625v.625a1.877,1.877,0,0,1-1.875,1.875H8A.625.625,0,0,0,8,16h2.375A3.129,3.129,0,0,0,13.5,12.875v-.688A3.13,3.13,0,0,0,16,9.125ZM3.75,7.25V11H3.125a1.875,1.875,0,0,1,0-3.75ZM12.875,11H12.25V7.25h.625a1.875,1.875,0,1,1,0,3.75Z"
                                        fill="#575b6a" />
                                    <path id="Path_40744" data-name="Path 40744"
                                        d="M197.875,113.25a.626.626,0,0,1,.625.625.618.618,0,0,1-.137.391,4.365,4.365,0,0,0-1.113,2.746v.613a.625.625,0,0,0,1.25,0v-.613a3.186,3.186,0,0,1,.838-1.964A1.875,1.875,0,1,0,196,113.875a.625.625,0,0,0,1.25,0A.626.626,0,0,1,197.875,113.25Z"
                                        transform="translate(-189.875 -108.5)" fill="#575b6a" />
                                    <circle id="Ellipse_891" data-name="Ellipse 891" cx="0.625" cy="0.625" r="0.625"
                                        transform="translate(7.375 11)" fill="#575b6a" />
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Support')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_support_tickets')): ?>
                            <?php
                                $support_ticket = DB::table('tickets')
                                                    ->where('viewed', 0)
                                                    ->select('id')
                                                    ->count();
                            ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('support_ticket.admin_index')); ?>"
                                    class="aiz-side-nav-link <?php echo e(areActiveRoutes(['support_ticket.admin_index', 'support_ticket.admin_show'])); ?>">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Ticket')); ?></span>
                                    <?php if($support_ticket > 0): ?><span class="badge badge-info"><?php echo e($support_ticket); ?></span><?php endif; ?>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_product_conversations')): ?>
                            <?php
                                $conversation = \App\Models\Conversation::where('receiver_id', Auth::user()->id)->where('receiver_viewed', '0')->get();
                            ?>
                            <li class="aiz-side-nav-item">
                                <a href="<?php echo e(route('conversations.admin_index')); ?>"
                                    class="aiz-side-nav-link <?php echo e(areActiveRoutes(['conversations.admin_index', 'conversations.admin_show'])); ?>">
                                    <span class="aiz-side-nav-text"><?php echo e(translate('Product Conversations')); ?></span>
                                    <?php if(count($conversation) > 0): ?>
                                        <span class="badge badge-info"><?php echo e(count($conversation)); ?></span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        <?php endif; ?>

                        <?php if(get_setting('product_query_activation') == 1): ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_product_queries')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('product_query.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['product_query.index','product_query.show'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Product Queries')); ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_contacts')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('contacts')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['contacts'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Contacts')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Affiliate Addon -->
                <?php if(addon_is_activated('affiliate_system')): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['affiliate_registration_form_config','affiliate_configurations','view_affiliate_users','view_all_referral_users','view_affiliate_withdraw_requests','view_affiliate_logs'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg id="Group_28297" data-name="Group 28297" xmlns="http://www.w3.org/2000/svg" width="16"
                                height="16" viewBox="0 0 16 16">
                                <path id="Path_40762" data-name="Path 40762"
                                    d="M43.75,273.875a1.875,1.875,0,1,0-1.875,1.875A1.877,1.877,0,0,0,43.75,273.875Zm-1.875.625a.625.625,0,1,1,.625-.625A.626.626,0,0,1,41.875,274.5Z"
                                    transform="translate(-38.75 -263.5)" fill="#575b6a" />
                                <path id="Path_40763" data-name="Path 40763"
                                    d="M3.125,392A3.129,3.129,0,0,0,0,395.125a.625.625,0,0,0,.625.625h5a.625.625,0,0,0,.625-.625A3.129,3.129,0,0,0,3.125,392Zm-1.768,2.5a1.875,1.875,0,0,1,3.536,0Z"
                                    transform="translate(0 -379.75)" fill="#575b6a" />
                                <path id="Path_40764" data-name="Path 40764"
                                    d="M355.75,273.875a1.875,1.875,0,1,0-1.875,1.875A1.877,1.877,0,0,0,355.75,273.875Zm-1.875.625a.625.625,0,1,1,.625-.625A.626.626,0,0,1,353.875,274.5Z"
                                    transform="translate(-341 -263.5)" fill="#575b6a" />
                                <path id="Path_40765" data-name="Path 40765"
                                    d="M315.125,392A3.129,3.129,0,0,0,312,395.125a.625.625,0,0,0,.625.625h5a.625.625,0,0,0,.625-.625A3.129,3.129,0,0,0,315.125,392Zm-1.768,2.5a1.875,1.875,0,0,1,3.536,0Z"
                                    transform="translate(-302.25 -379.75)" fill="#575b6a" />
                                <path id="Path_40766" data-name="Path 40766"
                                    d="M199.75,1.875a1.875,1.875,0,1,0-1.875,1.875A1.877,1.877,0,0,0,199.75,1.875Zm-1.875.625a.625.625,0,1,1,.625-.625A.626.626,0,0,1,197.875,2.5Z"
                                    transform="translate(-189.875)" fill="#575b6a" />
                                <path id="Path_40767" data-name="Path 40767"
                                    d="M156.625,123.75h5a.625.625,0,0,0,.625-.625,3.125,3.125,0,0,0-6.25,0A.625.625,0,0,0,156.625,123.75Zm2.5-2.5a1.878,1.878,0,0,1,1.768,1.25h-3.536A1.878,1.878,0,0,1,159.125,121.25Z"
                                    transform="translate(-151.125 -116.25)" fill="#575b6a" />
                                <path id="Path_40768" data-name="Path 40768"
                                    d="M180.893,279.472a.625.625,0,0,0-.173-.867l-1.6-1.064v-.915a.625.625,0,0,0-1.25,0v.915l-1.6,1.064a.625.625,0,1,0,.693,1.04l1.528-1.019,1.528,1.019A.625.625,0,0,0,180.893,279.472Z"
                                    transform="translate(-170.498 -267.375)" fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate System')); ?></span>
                        <?php if(env("DEMO_MODE") == "On"): ?>
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001" viewBox="0 0 16 14.001"
                                class="mx-2">
                                <path id="Union_49" data-name="Union 49"
                                    d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                    transform="translate(19337 -3329)" fill="#f51350" />
                            </svg>
                        <?php endif; ?>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_registration_form_config')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('affiliate.configs')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate Registration Form')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('affiliate_configurations')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('affiliate.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate Configurations')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_affiliate_users')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('affiliate.users')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['affiliate.users', 'affiliate_users.show_verification_request', 'affiliate_user.payment_history'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate Users')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_referral_users')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('refferals.users')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Referral Users')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_affiliate_withdraw_requests')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('affiliate.withdraw_requests')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate Withdraw Requests')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_affiliate_logs')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('affiliate.logs.admin')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Affiliate Logs')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php endif; ?>

                <!-- Offline Payment Addon-->
                <?php if(addon_is_activated('offline_payment')): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_manual_payment_methods','view_all_offline_payment_orders',
                'view_all_offline_wallet_recharges','view_all_offline_customer_package_payments','view_all_offline_seller_package_payments'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_28292" data-name="Group 28292" transform="translate(-1.25 -1.25)">
                                    <g id="Group_28290" data-name="Group 28290" transform="translate(1.25 9.644)">
                                        <path id="Path_40747" data-name="Path 40747"
                                            d="M10.706,20.168a3.576,3.576,0,0,1-1.517-.335L6.6,18.613a4.249,4.249,0,0,0-1.784-.4.562.562,0,0,1-.558-.558v-3.8a.562.562,0,0,1,.372-.528l1.286-.447a4.2,4.2,0,0,1,2.424-.089l4.238,1.139A1.419,1.419,0,0,1,13.6,14.973a1.2,1.2,0,0,1,.045.357v.134l1.941-.484a2.775,2.775,0,0,1,1.7.112,1.152,1.152,0,0,1,.1,2.106l-5.048,2.59a3.618,3.618,0,0,1-1.613.38ZM5.368,17.124a5.238,5.238,0,0,1,1.7.476l2.587,1.22a2.489,2.489,0,0,0,2.156-.03L16.87,16.2a1.3,1.3,0,0,0-1.033-.134l-3.688.923h-.022l-.223.06a.522.522,0,0,1-.216.007l-2.32-.342a.557.557,0,0,1,.164-1.1l2.208.327.059-.015.565-.32a.332.332,0,0,0,.164-.275c0-.007-.015-.082-.015-.089a.319.319,0,0,0-.23-.223L8.052,13.88a3.051,3.051,0,0,0-1.77.06l-.907.313v2.873Z"
                                            transform="translate(-2.022 -12.562)" fill="#575b6a" />
                                        <path id="Path_40748" data-name="Path 40748"
                                            d="M4.038,18.856H1.808A.562.562,0,0,1,1.25,18.3V13.088a.562.562,0,0,1,.558-.558h2.23a.562.562,0,0,1,.558.558V18.3A.562.562,0,0,1,4.038,18.856ZM2.365,17.739H3.48V13.646H2.365Z"
                                            transform="translate(-1.25 -12.53)" fill="#575b6a" />
                                    </g>
                                    <path id="Path_40749" data-name="Path 40749"
                                        d="M12.986,9.064H7.038A2.79,2.79,0,0,1,4.25,6.273V4.041A2.79,2.79,0,0,1,7.038,1.25h5.948a2.79,2.79,0,0,1,2.788,2.791V6.273A2.79,2.79,0,0,1,12.986,9.064Zm-5.948-6.7A1.676,1.676,0,0,0,5.365,4.041V6.273A1.676,1.676,0,0,0,7.038,7.948h5.948a1.676,1.676,0,0,0,1.673-1.674V4.041a1.676,1.676,0,0,0-1.673-1.674Z"
                                        transform="translate(-0.77)" fill="#575b6a" />
                                    <g id="Group_28291" data-name="Group 28291" transform="translate(5.042 2.545)">
                                        <path id="Path_40750" data-name="Path 40750"
                                            d="M16.592,6.746A.445.445,0,0,1,16.15,6.3V5.542a.442.442,0,1,1,.884,0V6.3A.445.445,0,0,1,16.592,6.746Z"
                                            transform="translate(-8.748 -3.315)" fill="#575b6a" />
                                        <path id="Path_40751" data-name="Path 40751"
                                            d="M6.792,6.745A.445.445,0,0,1,6.35,6.3V5.542a.442.442,0,1,1,.884,0V6.3A.445.445,0,0,1,6.792,6.745Z"
                                            transform="translate(-6.234 -3.314)" fill="#575b6a" />
                                        <path id="Path_40752" data-name="Path 40752"
                                            d="M11.535,4.673H10.316c-.085,0-.152-.055-.152-.1s.067-.1.152-.1h1.219a.457.457,0,0,0,0-.915h-.152v-.1a.457.457,0,1,0-.914,0v.1h-.152A1.047,1.047,0,0,0,9.25,4.57a1.043,1.043,0,0,0,1.066,1.018h1.219c.085,0,.152.055.152.1s-.067.1-.152.1H10.316a.457.457,0,0,0,0,.915h.152v.1a.457.457,0,1,0,.914,0v-.1h.152a1.02,1.02,0,1,0,0-2.037Z"
                                            transform="translate(-6.725 -2.519)" fill="#575b6a" />
                                    </g>
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Offline Payment System')); ?></span>
                        <?php if(env("DEMO_MODE") == "On"): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14.001" viewBox="0 0 16 14.001"
                            class="mx-2">
                            <path id="Union_49" data-name="Union 49"
                                d="M-19322,3342.5v-5a2.007,2.007,0,0,0-2-2v1.5a3,3,0,0,1-3,3h-4v-10h4a3,3,0,0,1,3,3v1.5a3,3,0,0,1,3,3v5a.506.506,0,0,1-.5.5A.5.5,0,0,1-19322,3342.5Zm-11-2V3339h-3a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v-7.5a.5.5,0,0,1,.5-.5.5.5,0,0,1,.5.5v11a.5.5,0,0,1-.5.5A.506.506,0,0,1-19333,3340.5Zm-3-7.5a1,1,0,0,1-1-1,1,1,0,0,1,1-1h3v2Z"
                                transform="translate(19337 -3329)" fill="#f51350" />
                        </svg>
                        <?php endif; ?>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_manual_payment_methods')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('manual_payment_methods.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['manual_payment_methods.index', 'manual_payment_methods.create', 'manual_payment_methods.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Manual Payment Methods')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_offline_payment_orders')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('offline_payment_orders.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Offline Payment Orders')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_offline_wallet_recharges')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('offline_wallet_recharge_request.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Offline Wallet Recharge')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>

                        <?php if(get_setting('classified_product') == 1 &&
                        auth()->user()->can('view_all_offline_customer_package_payments')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('offline_customer_package_payment_request.index')); ?>"
                                class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Offline Customer Package
                                    Payments')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if(addon_is_activated('seller_subscription') &&
                        auth()->user()->can('view_all_offline_seller_package_payments')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('offline_seller_package_payment_request.index')); ?>"
                                class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Offline Seller Package Payments')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
                <?php endif; ?>

                <!-- Paytm Addon -->
                

                <!-- Club Point Addon-->
                

                <!--OTP addon -->
                

                <!-- African Payment Gateway -->
                

                <!-- Website Setup -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['header_setup','footer_setup','view_all_website_pages','website_appearance','authentication_layout_settings'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link <?php echo e(areActiveRoutes(['website.footer', 'website.header'])); ?>">
                        <div class="aiz-side-nav-icon">
                            <svg id="Group_28315" data-name="Group 28315" xmlns="http://www.w3.org/2000/svg" width="16"
                                height="16" viewBox="0 0 16 16">
                                <circle id="Ellipse_893" data-name="Ellipse 893" cx="0.625" cy="0.625" r="0.625"
                                    transform="translate(7.375 6.125)" fill="#575b6a" />
                                <path id="Path_40777" data-name="Path 40777"
                                    d="M13.5,0H2.5A2.5,2.5,0,0,0,0,2.5V11a2.5,2.5,0,0,0,2.5,2.5H7.375v1.25H5.5A.625.625,0,0,0,5.5,16h5a.625.625,0,0,0,0-1.25H8.625V12.875A.625.625,0,0,0,8,12.25H2.5A1.251,1.251,0,0,1,1.25,11V2.5A1.251,1.251,0,0,1,2.5,1.25h11A1.251,1.251,0,0,1,14.75,2.5V11a1.251,1.251,0,0,1-1.25,1.25h-3a.625.625,0,0,0,0,1.25h3A2.5,2.5,0,0,0,16,11V2.5A2.5,2.5,0,0,0,13.5,0Z"
                                    fill="#575b6a" />
                                <path id="Path_40778" data-name="Path 40778"
                                    d="M120.375,84.75a.625.625,0,0,0,.625-.625v-.688a3.107,3.107,0,0,0,1.1-.456l.487.487a.625.625,0,0,0,.884-.884l-.487-.487a3.108,3.108,0,0,0,.456-1.1h.688a.625.625,0,1,0,0-1.25h-.688a3.108,3.108,0,0,0-.456-1.1l.487-.487a.625.625,0,0,0-.884-.884l-.487.487a3.107,3.107,0,0,0-1.1-.456v-.688a.625.625,0,0,0-1.25,0v.688a3.108,3.108,0,0,0-1.1.456l-.487-.487a.625.625,0,0,0-.884.884l.487.487a3.108,3.108,0,0,0-.456,1.1h-.688a.625.625,0,0,0,0,1.25h.688a3.108,3.108,0,0,0,.456,1.1l-.487.487a.625.625,0,0,0,.884.884l.487-.487a3.107,3.107,0,0,0,1.1.456v.688A.625.625,0,0,0,120.375,84.75ZM118.5,80.375a1.875,1.875,0,1,1,1.875,1.875A1.877,1.877,0,0,1,118.5,80.375Z"
                                    transform="translate(-112.375 -73.625)" fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Website Setup')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('select_homepage')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.select-homepage')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Select Homepage')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_website_page')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('custom-pages.edit', ['id'=>'home', 'lang'=>env('DEFAULT_LANGUAGE'), 'page'=>'home'])); ?>"
                                class="aiz-side-nav-link <?php echo e((url()->current() == url('/admin/website/custom-pages/edit/home')) ? 'active' : ''); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Homepage Settings')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('authentication_layout_settings')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.authentication-layout-settings')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Authentication Layout & Settings')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('header_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.header')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Header')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('footer_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.footer', ['lang'=>  App::getLocale()] )); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['website.footer'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Footer')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_website_pages')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.pages')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['website.pages', 'custom-pages.create' ,'custom-pages.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Pages')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('website_appearance')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('website.appearance')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Appearance')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Setup & Configurations -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['general_settings','features_activation','language_setup','currency_setup','vat_&_tax_setup',
                'pickup_point_setup','smtp_settings','payment_methods_configurations','order_configuration','file_system_&_cache_configuration',
                'social_media_logins','facebook_chat','facebook_comment','analytics_tools_configuration','google_recaptcha_configuration','google_map_setting',
                'google_firebase_setting','shipping_configuration','shipping_country_setting','manage_shipping_states','manage_shipping_cities','manage_zones','manage_carriers'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="Path_40779" data-name="Path 40779"
                                    d="M7.688,16h.625a1.877,1.877,0,0,0,1.875-1.875V13.81a.209.209,0,0,1,.133-.191l.011,0a.209.209,0,0,1,.23.041l.223.223a1.875,1.875,0,0,0,2.652,0l.442-.442a1.875,1.875,0,0,0,0-2.652l-.223-.223a.209.209,0,0,1-.041-.23l0-.012a.209.209,0,0,1,.191-.133h.315A1.877,1.877,0,0,0,16,8.313V7.688a1.877,1.877,0,0,0-1.875-1.875H13.81a.209.209,0,0,1-.191-.133l0-.011a.209.209,0,0,1,.041-.23l.223-.223a1.875,1.875,0,0,0,0-2.652l-.442-.442a1.875,1.875,0,0,0-2.652,0l-.223.223a.21.21,0,0,1-.23.041l-.012,0a.209.209,0,0,1-.133-.191V1.875A1.877,1.877,0,0,0,8.312,0H7.687A1.877,1.877,0,0,0,5.812,1.875V2.19a.209.209,0,0,1-.133.191l-.012,0a.209.209,0,0,1-.23-.041l-.223-.223a1.875,1.875,0,0,0-2.652,0l-.442.442a1.875,1.875,0,0,0,0,2.652l.223.223a.209.209,0,0,1,.041.23l0,.011a.209.209,0,0,1-.191.133H1.875A1.877,1.877,0,0,0,0,7.687v.625a1.874,1.874,0,0,0,1.407,1.816.625.625,0,1,0,.312-1.211.624.624,0,0,1-.468-.605V7.688a.626.626,0,0,1,.625-.625H2.19a1.455,1.455,0,0,0,1.347-.906l0-.011a1.455,1.455,0,0,0-.312-1.591l-.223-.223a.625.625,0,0,1,0-.884l.442-.442a.625.625,0,0,1,.884,0l.223.223a1.456,1.456,0,0,0,1.593.311l.009,0A1.455,1.455,0,0,0,7.063,2.19V1.875a.626.626,0,0,1,.625-.625h.625a.626.626,0,0,1,.625.625V2.19a1.455,1.455,0,0,0,.906,1.347l.009,0a1.455,1.455,0,0,0,1.593-.311l.223-.223a.625.625,0,0,1,.884,0l.442.442a.625.625,0,0,1,0,.884l-.223.223a1.455,1.455,0,0,0-.311,1.593l0,.009a1.455,1.455,0,0,0,1.347.906h.315a.626.626,0,0,1,.625.625v.625a.626.626,0,0,1-.625.625H13.81a1.455,1.455,0,0,0-1.347.906l0,.009a1.455,1.455,0,0,0,.311,1.593l.223.223a.625.625,0,0,1,0,.884l-.442.442a.625.625,0,0,1-.884,0l-.223-.223a1.456,1.456,0,0,0-1.593-.311l-.009,0a1.455,1.455,0,0,0-.906,1.347v.315a.626.626,0,0,1-.625.625H7.688a.622.622,0,0,1-.6-.437.625.625,0,1,0-1.193.375A1.867,1.867,0,0,0,7.688,16ZM.536,15.433a1.829,1.829,0,0,1,0-2.586h0L4.589,8.811a3.234,3.234,0,0,1-.308-1.259,2.97,2.97,0,0,1,.9-2.141A4.228,4.228,0,0,1,8.13,4.255h.007a3.322,3.322,0,0,1,1.086.188A.625.625,0,0,1,9.47,5.473L7.964,7.01l.188.811L8.95,8,10.479,6.47a.625.625,0,0,1,1.034.24,3.472,3.472,0,0,1,.2,1.121,4.373,4.373,0,0,1-.8,2.556,3.047,3.047,0,0,1-2.49,1.3H8.417A3.414,3.414,0,0,1,7.159,11.4L3.122,15.433a1.829,1.829,0,0,1-2.586,0Zm6.876-5.311a2.1,2.1,0,0,0,1.007.316,1.818,1.818,0,0,0,1.487-.792,2.988,2.988,0,0,0,.528-1.361l-.843.845A.625.625,0,0,1,9.01,9.3L7.494,8.953a.625.625,0,0,1-.471-.468L6.669,6.959a.625.625,0,0,1,.162-.579l.823-.84A2.844,2.844,0,0,0,6.067,6.3,1.723,1.723,0,0,0,5.531,7.55a2.123,2.123,0,0,0,.342,1,.625.625,0,0,1-.065.809L1.419,13.731a.579.579,0,1,0,.819.818l4.368-4.361a.625.625,0,0,1,.806-.066Z"
                                    fill="#575b6a" />
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Setup & Configurations')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('features_activation')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('activation.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Features activation')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('language_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('languages.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['languages.index', 'languages.create', 'languages.store', 'languages.show', 'languages.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Languages')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('currency_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('currency.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Currency')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('vat_&_tax_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('tax.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['tax.index', 'tax.create', 'tax.store', 'tax.show', 'tax.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Vat & TAX')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pickup_point_setup')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('pick_up_points.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['pick_up_points.index','pick_up_points.create','pick_up_points.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Pickup point')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('smtp_settings')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('smtp_settings.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('SMTP Settings')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment_methods_configurations')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('payment_method.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Payment Methods')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('order_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('order_configuration.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Order Configuration')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('file_system_&_cache_configuration')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('file_system.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('File System & Cache
                                    Configuration')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('social_media_logins')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('social_login.index')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Social media Logins')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['facebook_chat','facebook_comment'])): ?>
                        <li class="aiz-side-nav-item">
                            <a href="javascript:void(0);" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Facebook')); ?></span>
                                <span class="aiz-side-nav-arrow"></span>
                            </a>
                            <ul class="aiz-side-nav-list level-3">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('facebook_chat')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('facebook_chat.index')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Facebook Chat')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('facebook_comment')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('facebook-comment')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Facebook Comment')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['analytics_tools_configuration','google_recaptcha_configuration','google_map_setting','google_firebase_setting'])): ?>
                        <li class="aiz-side-nav-item">
                            <a href="javascript:void(0);" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Google')); ?></span>
                                <span class="aiz-side-nav-arrow"></span>
                            </a>
                            <ul class="aiz-side-nav-list level-3">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('analytics_tools_configuration')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('google_analytics.index')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Analytics Tools')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('google_recaptcha_configuration')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('google_recaptcha.index')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Google reCAPTCHA')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('google_map_setting')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('google-map.index')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Google Map')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('google_firebase_setting')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('google-firebase.index')); ?>" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Google Firebase')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['shipping_configuration','shipping_country_setting','manage_shipping_states','manage_shipping_cities','manage_zones','manage_carriers'])): ?>
                        <li class="aiz-side-nav-item">
                            <a href="javascript:void(0);" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Shipping')); ?></span>
                                <span class="aiz-side-nav-arrow"></span>
                            </a>
                            <ul class="aiz-side-nav-list level-3">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shipping_configuration')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('shipping_configuration.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['shipping_configuration.index','shipping_configuration.edit','shipping_configuration.update'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Shipping Configuration')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('shipping_country_setting')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('countries.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['countries.index','countries.edit','countries.update'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Shipping Countries')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_shipping_states')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('states.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['states.index','states.edit','states.update'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Shipping States')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_shipping_cities')): ?>
                                <li class="aiz-side-nav-item">
                                    <a href="<?php echo e(route('cities.index')); ?>"
                                        class="aiz-side-nav-link <?php echo e(areActiveRoutes(['cities.index','cities.edit','cities.update'])); ?>">
                                        <span class="aiz-side-nav-text"><?php echo e(translate('Shipping Cities')); ?></span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                
                                
                            </ul>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Staffs -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['view_all_staffs','view_staff_roles'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_28314" data-name="Group 28314" transform="translate(-19299 2175)">
                                    <path id="Path_40774" data-name="Path 40774"
                                        d="M87.867,3.07H84.133V1.72A.716.716,0,0,0,83.422,1H80.578a.716.716,0,0,0-.711.72V3.07H76.133A2.149,2.149,0,0,0,74,5.229V14.84A2.149,2.149,0,0,0,76.133,17H87.867A2.149,2.149,0,0,0,90,14.84V5.229A2.149,2.149,0,0,0,87.867,3.07Zm-6.578-.63h1.422V3.79a.711.711,0,1,1-1.422,0Zm7.289,12.4a.716.716,0,0,1-.711.72H76.133a.716.716,0,0,1-.711-.72V5.229a.716.716,0,0,1,.711-.72h3.856a2.124,2.124,0,0,0,4.022,0h3.856a.716.716,0,0,1,.711.72Z"
                                        transform="translate(19225 -2176)" fill="#575b6a" />
                                    <g id="Group_28312" data-name="Group 28312"
                                        transform="translate(19305.07 -2169.197)">
                                        <path id="Path_40775" data-name="Path 40775"
                                            d="M199.864,197.932a1.932,1.932,0,1,0-1.932,1.932A1.934,1.934,0,0,0,199.864,197.932Zm-1.932.644a.644.644,0,1,1,.644-.644A.645.645,0,0,1,197.932,198.576Z"
                                            transform="translate(-196 -196)" fill="#575b6a" />
                                    </g>
                                    <g id="Group_28313" data-name="Group 28313" transform="translate(19303.779 -2165)">
                                        <path id="Path_40776" data-name="Path 40776"
                                            d="M160.508,316h-2.576A1.934,1.934,0,0,0,156,317.932v1.288a.644.644,0,1,0,1.288,0v-1.288a.645.645,0,0,1,.644-.644h2.576a.645.645,0,0,1,.644.644v1.288a.644.644,0,1,0,1.288,0v-1.288A1.934,1.934,0,0,0,160.508,316Z"
                                            transform="translate(-156 -316)" fill="#575b6a" />
                                    </g>
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('Staffs')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_all_staffs')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('staffs.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['staffs.index', 'staffs.create', 'staffs.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('All staffs')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_staff_roles')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('roles.index')); ?>"
                                class="aiz-side-nav-link <?php echo e(areActiveRoutes(['roles.index', 'roles.create', 'roles.edit'])); ?>">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Staff permissions')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- System Update & Server Status -->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['system_update','server_status'])): ?>
                <li class="aiz-side-nav-item">
                    <a href="#" class="aiz-side-nav-link">
                        <div class="aiz-side-nav-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_28317" data-name="Group 28317" transform="translate(-19315.001 1976)">
                                    <g id="layer1" transform="translate(19314.471 -1976.53)">
                                        <path id="path3159"
                                            d="M3.386.53A2.862,2.862,0,0,0,.53,3.386V13.67a2.865,2.865,0,0,0,2.856,2.86H13.67a2.869,2.869,0,0,0,2.86-2.86V3.386A2.865,2.865,0,0,0,13.67.53Zm0,1.143H13.67a1.7,1.7,0,0,1,1.718,1.713V13.67a1.7,1.7,0,0,1-1.718,1.718H3.386A1.7,1.7,0,0,1,1.673,13.67V3.386A1.7,1.7,0,0,1,3.386,1.673Z"
                                            fill="#575b6a" />
                                    </g>
                                    <g id="Group_28316" data-name="Group 28316"
                                        transform="translate(19317.551 -1973.449)">
                                        <g id="LWPOLYLINE" transform="translate(0 3.708)">
                                            <path id="Path_25666" data-name="Path 25666"
                                                d="M194.061,143.129a.436.436,0,0,0,0,.873h1.527a.436.436,0,0,0,0-.873Z"
                                                transform="translate(-193.625 -143.129)" fill="#575b6a" />
                                        </g>
                                        <g id="LWPOLYLINE-2" data-name="LWPOLYLINE" transform="translate(3.663)">
                                            <path id="Path_25667" data-name="Path 25667"
                                                d="M199.926,137.186a.436.436,0,0,1,.872,0v1.527a.436.436,0,0,1-.872,0Z"
                                                transform="translate(-199.926 -136.75)" fill="#575b6a" />
                                        </g>
                                        <g id="LWPOLYLINE-3" data-name="LWPOLYLINE" transform="translate(5.239 1.075)">
                                            <path id="Path_25668" data-name="Path 25668"
                                                d="M204.463,139.345a.436.436,0,1,0-.617-.617l-1.079,1.079a.436.436,0,1,0,.617.617Z"
                                                transform="translate(-202.638 -138.6)" fill="#575b6a" />
                                        </g>
                                        <g id="LWPOLYLINE-4" data-name="LWPOLYLINE" transform="translate(1.097 1.075)">
                                            <path id="Path_25669" data-name="Path 25669"
                                                d="M195.64,139.345a.436.436,0,1,1,.617-.617l1.079,1.079a.436.436,0,1,1-.617.617Z"
                                                transform="translate(-195.512 -138.6)" fill="#575b6a" />
                                        </g>
                                        <g id="LWPOLYLINE-5" data-name="LWPOLYLINE" transform="translate(1.097 5.261)">
                                            <path id="Path_25670" data-name="Path 25670"
                                                d="M195.64,147.008a.436.436,0,0,0,.617.617l1.079-1.079a.436.436,0,1,0-.617-.617Z"
                                                transform="translate(-195.512 -145.8)" fill="#575b6a" />
                                        </g>
                                        <path id="Path_25671" data-name="Path 25671"
                                            d="M206.87,148.144,205,146.269l.864-.471a.436.436,0,0,0-.044-.786l-5.682-2.322a.436.436,0,0,0-.569.568l2.322,5.682a.436.436,0,0,0,.786.044l.471-.864,1.875,1.875a.437.437,0,0,0,.617,0l1.233-1.233A.437.437,0,0,0,206.87,148.144Zm-1.544.913-1.977-1.977a.436.436,0,0,0-.691.1l-.311.57-1.58-3.868,3.868,1.58-.57.311a.436.436,0,0,0-.174.591.467.467,0,0,0,.074.1l1.977,1.977Z"
                                            transform="translate(-196.099 -139.223)" fill="#575b6a" />
                                    </g>
                                </g>
                            </svg>
                        </div>
                        <span class="aiz-side-nav-text"><?php echo e(translate('System')); ?></span>
                        <span class="aiz-side-nav-arrow"></span>
                    </a>
                    <ul class="aiz-side-nav-list level-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('system_update')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('system_update')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Update')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('server_status')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('system_server')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Server status')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('server_status')): ?>
                        <li class="aiz-side-nav-item">
                            <a href="<?php echo e(route('import_demo_data')); ?>" class="aiz-side-nav-link">
                                <span class="aiz-side-nav-text"><?php echo e(translate('Import Demo Data')); ?></span>
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <!-- Addon Manager -->
                
            </ul><!-- .aiz-side-nav -->
        </div><!-- .aiz-side-nav-wrap -->
    </div><!-- .aiz-sidebar -->
    <div class="aiz-sidebar-overlay"></div>
</div><!-- .aiz-sidebar --><?php /**PATH /home2/akshathealthcare/public_html/resources/views/backend/inc/admin_sidenav.blade.php ENDPATH**/ ?>