<?php $__env->startSection('content'); ?>

    <section class="mb-4 mt-3">
        <div class="container text-left">
            <div class="bg-white shadow-sm rounded">
                <div class="py-3 d-flex justify-content-between align-items-center">
                    <div class="fs-16 fs-md-20 fw-700 text-dark"><?php echo e(translate('Compare Products')); ?></div>
                    <a href="<?php echo e(route('compare.reset')); ?>" style="text-decoration: none;border-radius: 25px;" class="btn btn-soft-primary btn-sm fs-12 fw-600"><?php echo e(translate('Reset Compare List')); ?></a>
                </div>
                <?php if(Session::has('compare')): ?>
                    <?php if(count(Session::get('compare')) > 0): ?>
                        <div class="py-3">
                            <div class="row gutters-16 mb-4">
                                <?php $__currentLoopData = Session::get('compare'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $product = get_single_product($item);
                                    ?>
                                    <div class="col-xl-3 col-lg-4 col-md-6 py-3">
                                        <div class="border">
                                            <!-- Product Name -->
                                            <div class="p-4 border-bottom">
                                                <span class="fs-12 text-gray"><?php echo e(translate('Name')); ?></span>
                                                <h5 class="mb-0 text-dark h-45px text-truncate-2 mt-1">
                                                    <a class="text-reset fs-14 fw-700 hov-text-primary" href="<?php echo e(route('product', get_single_product($item)->slug)); ?>" title="<?php echo e(get_single_product($item)->getTranslation('name')); ?>">
                                                        <?php echo e(get_single_product($item)->getTranslation('name')); ?>

                                                    </a>
                                                </h5>
                                            </div>
                                            <!-- Product Image -->
                                            <div class="p-4 border-bottom">
                                                <span class="fs-12 text-gray"><?php echo e(translate('Image')); ?></span>
                                                <div>
                                                    <img loading="lazy" src="<?php echo e(uploaded_asset(get_single_product($item)->thumbnail_img)); ?>" alt="<?php echo e(translate('Product Image')); ?>" class="img-fluid py-4 h-180px h-sm-220px">
                                                </div>
                                            </div>
                                            <!-- Price -->
                                            <div class="p-4 border-bottom">
                                                <span class="fs-12 text-gray"><?php echo e(translate('Price')); ?></span>
                                                <h5 class="mb-0 fs-14 mt-1">
                                                    <?php if(home_base_price($product) != home_discounted_base_price($product)): ?>
                                                        <del class="fw-400 opacity-50 mr-1"><?php echo e(home_base_price($product)); ?></del>
                                                    <?php endif; ?>
                                                    <span class="fw-700 text-primary"><?php echo e(home_discounted_base_price($product)); ?></span>
                                                </h5>
                                            </div>
                                            <!-- Category -->
                                            <div class="p-4 border-bottom">
                                                <span class="fs-12 text-gray"><?php echo e(translate('Category')); ?></span>
                                                <h5 class="mb-0 fs-14 text-dark mt-1">
                                                    <?php if(get_single_product($item)->main_category != null): ?>
                                                        <?php echo e(get_single_product($item)->main_category->getTranslation('name')); ?>

                                                    <?php endif; ?>
                                                </h5>
                                            </div>
                                            <!-- Brand -->
                                            <div class="p-4 border-bottom">
                                                <span class="fs-12 text-gray"><?php echo e(translate('Company')); ?></span>
                                                <h5 class="mb-0 fs-14 text-dark mt-1">
                                                    <?php if(get_single_product($item)->brand != null): ?>
                                                        <?php echo e(get_single_product($item)->brand->getTranslation('name')); ?>

                                                    <?php endif; ?>
                                                </h5>
                                            </div>
                                            <!-- Add to cart -->
                                            <div class="p-4">
                                                <button type="button" class="btn btn-block btn-dark rounded-0 fs-13 fw-700 has-transition opacity-80 hov-opacity-100" onclick="showAddToCartModal(<?php echo e($item); ?>)">
                                                    <?php echo e(translate('Add to cart')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center p-4">
                        <p class="fs-17"><?php echo e(translate('Your comparison list is empty')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/akshathealthcare/public_html/resources/views/frontend/view_compare.blade.php ENDPATH**/ ?>